/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.doctor;

import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.ExceptionUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.doctor.analyzer.ExceptionAnalyzer;
import mod.fuji.module.initializer.doctor.analyzer.FujiModuleMixinApplicationExceptionAnalyzer;
import mod.fuji.module.initializer.doctor.analyzer.GenericModMixinApplicationExceptionAnalyzer;
import org.jetbrains.annotations.NotNull;

@Document(id=1757426112765L, value="This module provides the `server crash analyzer` when the `server crashed`.\n")
public class DoctorInitializer
extends ModuleInitializer {
    @NotNull
    private static List<ExceptionAnalyzer> makeExceptionAnalyzers() {
        return List.of(new FujiModuleMixinApplicationExceptionAnalyzer(), new GenericModMixinApplicationExceptionAnalyzer());
    }

    public static void analyzeCaptureThrowable(@NotNull Throwable throwable) {
        List<Throwable> throwableChain = ExceptionUtil.getThrowableChain(throwable);
        String causeChain = DoctorInitializer.formatCauseChain(throwableChain);
        StringBuilder diagnosisBuilder = new StringBuilder();
        DoctorInitializer.makeExceptionAnalyzers().stream().map(it -> it.analyze(throwableChain, causeChain)).filter(Optional::isPresent).map(Optional::get).forEach(diagnosisBuilder::append);
        String diagnosis = diagnosisBuilder.toString();
        if (diagnosis.isBlank()) {
            diagnosis = "None, see logs above for details.";
        }
        String formatString = "\n[Server Crash Analyzer]\n\n\u25c9 Cause Chain\n{}\nTime Order: {}\n\n\u25c9 Diagnosis\n{}\n\n----- Server Program Terminated Here -----\n";
        formatString = LogUtil.AnsiColor.wrapAnsiColorCode(formatString, "\u001b[32m");
        String timeOrder = DoctorInitializer.formatTimeOrder(throwableChain);
        LogUtil.warn(formatString, causeChain, timeOrder, diagnosis);
    }

    @NotNull
    private static String formatCauseChain(@NotNull List<Throwable> throwableChain) {
        StringBuilder sb = new StringBuilder();
        for (int index = throwableChain.size() - 1; index >= 0; --index) {
            Throwable t = throwableChain.get(index);
            sb.append("[%d]".formatted(index)).append(" ").append(t.getClass().getName()).append(": ").append(t.getMessage()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static String formatTimeOrder(@NotNull List<Throwable> throwableChain) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < throwableChain.size(); ++i) {
            sb.append("[").append(i).append("]");
            if (i >= throwableChain.size() - 1) continue;
            sb.append(" -> ");
        }
        return sb.toString();
    }
}

