/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.economy.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.economy.service.EconomyService;
import mod.fuji.module.initializer.economy.structure.GameProfileAndEconomyAccount;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalanceTopGui
extends PagedGui<GameProfileAndEconomyAccount> {
    private final class_2960 currencyId;

    public BalanceTopGui(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2960 currencyId, @NotNull List<GameProfileAndEconomyAccount> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "economy.balance.top.gui.title", currencyId), entities, pageIndex);
        this.currencyId = currencyId;
    }

    @Override
    @NotNull
    protected PagedGui<GameProfileAndEconomyAccount> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<GameProfileAndEconomyAccount> entities, int pageIndex) {
        return new BalanceTopGui(parent, player, this.currencyId, entities, pageIndex);
    }

    public static BalanceTopGui make(class_3222 player, class_2960 currencyId) {
        List<GameProfileAndEconomyAccount> entities = EconomyService.makeBalanceTopEntities(player, currencyId);
        return new BalanceTopGui(null, player, currencyId, entities, 0);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull GameProfileAndEconomyAccount entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "economy.balance", TextHelper.Operators.getString(entity.economyAccount.formattedBalance())));
        String name = AuthlibHelper.getName(entity.gameProfile);
        GuiElementBuilder builder = GuiHelper.Button.makeLuckyBlockButton().setName((class_2561)class_2561.method_43470((String)name)).setLore(lore);
        return builder.build();
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        GuiHelper.PlayerSkull.fillPlayerHeadTextures((SlotGuiInterface)this);
    }
}

