/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import mod.fuji.core.document.descriptor.MetaDescriptor;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.util.Tristate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckpermsHelper {
    private static LuckPerms instance;

    private static Optional<LuckPerms> getAPI() {
        if (instance == null) {
            try {
                instance = LuckPermsProvider.get();
            }
            catch (Exception ignored) {
                return Optional.empty();
            }
            return Optional.of(instance);
        }
        return Optional.of(instance);
    }

    private static User loadUser(@NotNull LuckPerms api, @NotNull UUID uuid) {
        UserManager userManager = api.getUserManager();
        if (userManager.isLoaded(uuid)) {
            return userManager.getUser(uuid);
        }
        CompletableFuture userFuture = userManager.loadUser(uuid);
        return (User)userFuture.join();
    }

    @NotNull
    public static Tristate getPermission(@NotNull UUID uuid, @Nullable PermissionDescriptor permissionDescriptor, Object ... arguments) {
        Optional<LuckPerms> api = LuckpermsHelper.getAPI();
        return api.map($api -> {
            if (permissionDescriptor == null) {
                return null;
            }
            String permissionString = permissionDescriptor.withArguments(arguments);
            if (permissionString == null || permissionString.isEmpty()) {
                return null;
            }
            User user = LuckpermsHelper.loadUser($api, uuid);
            return user.getCachedData().getPermissionData().checkPermission(permissionString);
        }).orElse(Tristate.UNDEFINED);
    }

    public static boolean hasPermission(@NotNull UUID uuid, @Nullable PermissionDescriptor permissionDescriptor, Object ... arguments) {
        return LuckpermsHelper.getPermission(uuid, permissionDescriptor, arguments).asBoolean();
    }

    @NotNull
    public static <T> Optional<T> getMeta(@NotNull UUID uuid, @Nullable MetaDescriptor<T> metaDescriptor, Object ... arguments) {
        Optional<LuckPerms> api = LuckpermsHelper.getAPI();
        return api.map($api -> {
            if (metaDescriptor == null) {
                return null;
            }
            String metaString = metaDescriptor.withArguments(arguments);
            if (metaString == null || metaString.isEmpty()) {
                return null;
            }
            User user = LuckpermsHelper.loadUser($api, uuid);
            Optional metaValue = user.getCachedData().getMetaData().getMetaValue(metaString, metaDescriptor.valueTransformer);
            return metaValue.orElse(null);
        });
    }

    @NotNull
    public static String getPrefix(UUID uuid) {
        Optional<LuckPerms> api = LuckpermsHelper.getAPI();
        return api.map($api -> {
            User user = LuckpermsHelper.loadUser($api, uuid);
            return user.getCachedData().getMetaData().getPrefix();
        }).orElse("");
    }

    @NotNull
    public static String getSuffix(UUID uuid) {
        Optional<LuckPerms> api = LuckpermsHelper.getAPI();
        return api.map($api -> {
            User user = LuckpermsHelper.loadUser($api, uuid);
            return user.getCachedData().getMetaData().getSuffix();
        }).orElse("");
    }
}

