/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.event.consumer;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import mod.fuji.core.event.consumer.BaseEventConsumer;
import mod.fuji.core.event.graph.structure.EventConsumerInfo;
import mod.fuji.core.event.message.BaseEvent;
import org.jetbrains.annotations.NotNull;

public class StaticEventConsumer<T>
extends BaseEventConsumer<T> {
    private StaticEventConsumer(EventConsumerInfo eventConsumerInfo, Class<T> eventType, Consumer<T> consumer) {
        super(eventConsumerInfo, eventType, consumer);
    }

    @NotNull
    private static <E> Consumer<E> toConsumer(@NotNull Class<E> eventType, @NotNull Method method) {
        method.setAccessible(true);
        MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(method.getDeclaringClass(), MethodHandles.lookup());
        MethodHandle handle = lookup.unreflect(method);
        MethodType factoryType = MethodType.methodType(Consumer.class);
        MethodType methodType = MethodType.methodType(Void.TYPE, eventType);
        CallSite site = LambdaMetafactory.metafactory(lookup, "accept", factoryType, MethodType.methodType(Void.TYPE, Object.class), handle, methodType);
        return site.getTarget().invoke();
    }

    public static <T extends BaseEvent> BaseEventConsumer<T> makeStatic(@NotNull EventConsumerInfo eventConsumerInfo, @NotNull Class<T> eventType, @NotNull Method eventConsumerMethod) {
        Consumer<T> consumer = StaticEventConsumer.toConsumer(eventType, eventConsumerMethod);
        return new StaticEventConsumer<T>(eventConsumerInfo, eventType, consumer);
    }
}

