/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.chat.display;

import mod.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.PlaceholderDescriptor;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.chat.display.config.model.ChatDisplayConfigModel;
import mod.fuji.module.initializer.chat.display.helper.DisplayHelper;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

@Document(id=1751826642157L, value="This module allows players to show things to others:\n1. Show their main-hand item.\n2. Show their inventory.\n3. Show their ender chest.\n")
@ColorBoxes(value={@ColorBox(id=1759153524537L, color=ColorBox.ColorBoxTypes.NOTE, value="\u25c9 Advanced `server-side` show-case mod.\nA new mod is released in https://modrinth.com/mod/showcase\nYou may want to check it!\n"), @ColorBox(id=1751870533687L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 This module is designed to work with other `chat-related` mods.\nFor example, you use this with `Styled Chat` mod.\n"), @ColorBox(id=1751870535947L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Define a `chat shortcut` to create a display\nYou can use `chat.replace` module, to define chat shortcut.\nThe shortcut can be `\"item\"` for example.\nThen you can type `\"item\"` in chat.\nTo create a display directly using chat, without the commands.\n")})
public class ChatDisplayInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<ChatDisplayConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatDisplayConfigModel.class);
    private static final String DISPLAY_TEXT_PLACEHOLDER = "display";

    private static void broadcastDisplayText(class_3222 player, String broadcastTextKey, class_5250 displayText) {
        class_2561 broadcastText = TextHelper.getTextByKey(player, broadcastTextKey, new Object[0]);
        broadcastText = TextHelper.Replacer.replaceTextWithNamedArgument(broadcastText, DISPLAY_TEXT_PLACEHOLDER, matcher -> displayText);
        TextHelper.sendBroadcastByText(broadcastText);
    }

    @Document(id=1751826645846L, value="Show your item in main hand.")
    @CommandNode(value="chat display item")
    private static int $displayItem(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.item.broadcast", DisplayHelper.createItemDisplayText(player));
        return 1;
    }

    @Document(id=1751826648229L, value="Show your inventory.")
    @CommandNode(value="chat display inv")
    private static int $displayInv(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.inventory.broadcast", DisplayHelper.createInvDisplayText(player));
        return 1;
    }

    @Document(id=1751826650468L, value="Show your enderchest.")
    @CommandNode(value="chat display ender")
    private static int $displayEnder(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.ender_chest.broadcast", DisplayHelper.createEnderDisplayText(player));
        return 1;
    }

    @DocStringProvider(id=1752000261529L, value="Create a `enderchest display` and return the `clickable` text to open that display.\n")
    private static void registerDisplayEnderPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("ender", 1752000261529L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, DisplayHelper::createEnderDisplayText);
    }

    @DocStringProvider(id=1752000274945L, value="Create a `inventory display` and return the `clickable` text to open that display.\n")
    private static void registerDisplayInvPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("inv", 1752000274945L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, DisplayHelper::createInvDisplayText);
    }

    @DocStringProvider(id=1752000288451L, value="Create a `item display` and return the `clickable` text to open that display.\n")
    private static void registerDisplayItemPlaceholder() {
        PlaceholderDescriptor descriptor = new PlaceholderDescriptor("item", 1752000288451L);
        PlaceholderHelper.registerPlayerPlaceholder(descriptor, DisplayHelper::createItemDisplayText);
    }

    @Override
    protected void registerPlaceholders() {
        ChatDisplayInitializer.registerDisplayItemPlaceholder();
        ChatDisplayInitializer.registerDisplayInvPlaceholder();
        ChatDisplayInitializer.registerDisplayEnderPlaceholder();
    }
}

