/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.module.initializer.world.manager.command.argument.wrapper.UnloadedRuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.service.WorldService;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_2232;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class UnloadedRuntimeDimensionDescriptorArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return class_2232.method_9441();
    }

    @Override
    protected Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        class_2960 identifier = class_2232.method_9443(context, (String)commandArgument.getArgumentName());
        Optional<RuntimeDimensionDescriptor> runtimeDimensionDescriptor = WorldService.getRuntimeDimensionDescriptor(identifier.toString());
        return runtimeDimensionDescriptor.map($runtimeDimensionDescriptor -> {
            if (!$runtimeDimensionDescriptor.isDimensionLoaded()) {
                return new UnloadedRuntimeDimensionDescriptor((RuntimeDimensionDescriptor)$runtimeDimensionDescriptor);
            }
            TextHelper.sendTextByKey(context.getSource(), "world.dimension.load.already", identifier);
            throw new AbortCommandExecutionException();
        }).orElseThrow(() -> {
            TextHelper.sendTextByKey(context.getSource(), "world.dimension.dimension_descriptor_not_found", identifier);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(UnloadedRuntimeDimensionDescriptor.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("unloaded-runtime-dimension-descriptor");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(() -> WorldService.getRuntimeDimensionDescriptors().stream().filter(it -> !it.isDimensionLoaded()).map(RuntimeDimensionDescriptor::getDimension).toList()));
    }
}

