/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary;

import io.github.sakurawald.Fuji;
import io.github.sakurawald.core.auxiliary.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

public final class IOUtil {
    public static void compressFiles(@NotNull File base, @NotNull List<File> input, @NotNull File output) {
        int BUFFER_SIZE = 4096;
        try (FileOutputStream fos = new FileOutputStream(output);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (File file : input) {
                if (!file.isFile()) continue;
                try (FileInputStream fis = new FileInputStream(file);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(IOUtil.computeEntryName(base, file));
                    zos.putNextEntry(zipEntry);
                    byte[] buffer = new byte[4096];
                    while ((length = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, length);
                    }
                    zos.closeEntry();
                }
            }
        }
    }

    @NotNull
    private static String computeEntryName(@NotNull File base, @NotNull File file) {
        return IOUtil.computeRelativePath(base, file);
    }

    public static String computeRelativePath(@NotNull File base, @NotNull File file) {
        String baseStr = base.getCanonicalPath();
        String fileStr = file.getCanonicalPath();
        return fileStr.replace(baseStr, "");
    }

    public static String computeRelativePath(@NotNull File file) {
        return IOUtil.computeRelativePath(Fuji.CONFIG_PATH.getParent().toFile(), file);
    }

    @NotNull
    public static List<Path> listLatestFiles(@NotNull Path path) {
        List<Path> list;
        block8: {
            Stream<Path> files = Files.list(path);
            try {
                list = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted((o1, o2) -> {
                    try {
                        FileTime t1 = Files.readAttributes(o1, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                        FileTime t2 = Files.readAttributes(o2, BasicFileAttributes.class, new LinkOption[0]).creationTime();
                        return t1.compareTo(t2);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            files.close();
        }
        return list;
    }

    private static String requestPost(@NotNull URI uri, @NotNull String param) throws IOException {
        LogUtil.debug("Send a post request: uri = {}, param = {}", uri, param);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("User-Agent", "Fuji");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        IOUtils.write((byte[])param.getBytes(StandardCharsets.UTF_8), (OutputStream)connection.getOutputStream());
        return IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    private static String requestGet(@NotNull URI uri) throws IOException {
        LogUtil.debug("Send a get request: uri = {}", uri);
        HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
        connection.setRequestMethod("GET");
        connection.setDoOutput(true);
        return IOUtils.toString((InputStream)connection.getInputStream(), (Charset)StandardCharsets.UTF_8);
    }

    public static String requestGet(@NotNull String uri) throws IOException {
        return IOUtil.requestGet(URI.create(uri));
    }

    public static String requestPost(@NotNull String uri, @NotNull String param) throws IOException {
        return IOUtil.requestPost(URI.create(uri), param);
    }

    private IOUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

