/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.argument.adapter.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.core.command.argument.structure.Argument;
import io.github.sakurawald.core.command.argument.wrapper.impl.OfflinePlayerName;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_3312;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @NotNull
    private static List<String> getPlayerNameListFromUserCache() {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return List.of();
        }
        ArrayList<String> playerNames = new ArrayList<String>();
        userCache.field_14312.values().forEach(o -> playerNames.add(o.method_14519().getName()));
        return playerNames;
    }

    @Override
    public ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    public RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests((context, builder) -> {
            OfflinePlayerArgumentTypeAdapter.getPlayerNameListFromUserCache().forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        });
    }

    @Override
    public Object makeArgumentObject(CommandContext<class_2168> context, Argument argument) {
        return new OfflinePlayerName(StringArgumentType.getString(context, (String)argument.getArgumentName()));
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(OfflinePlayerName.class);
    }

    @Override
    public List<String> getTypeStrings() {
        return List.of("offline-player");
    }
}

