/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.display;

import io.github.sakurawald.core.auxiliary.minecraft.PlaceholderHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.display.config.model.ChatDisplayConfigModel;
import io.github.sakurawald.module.initializer.chat.display.helper.DisplayHelper;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class ChatDisplayInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<ChatDisplayConfigModel> config = new ObjectConfigurationHandler<ChatDisplayConfigModel>("config.json", ChatDisplayConfigModel.class);
    private static final String DISPLAY_TEXT_PLACEHOLDER = "display";

    private static void broadcastDisplayText(class_3222 player, String broadcastTextKey, class_5250 displayText) {
        class_2561 broadcastText = TextHelper.getTextByKey(player, broadcastTextKey, new Object[0]);
        broadcastText = TextHelper.replaceTextWithMarker(broadcastText, DISPLAY_TEXT_PLACEHOLDER, () -> displayText);
        TextHelper.sendBroadcastByValue(broadcastText);
    }

    @CommandNode(value="chat display item")
    private static int $displayItem(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.item.broadcast", DisplayHelper.createItemDisplayText(player));
        return 1;
    }

    @CommandNode(value="chat display inv")
    private static int $displayInv(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.inventory.broadcast", DisplayHelper.createInvDisplayText(player));
        return 1;
    }

    @CommandNode(value="chat display ender")
    private static int $displayEnder(@CommandSource class_3222 player) {
        ChatDisplayInitializer.broadcastDisplayText(player, "display.ender_chest.broadcast", DisplayHelper.createEnderDisplayText(player));
        return 1;
    }

    private static void registerDisplayEnderPlaceholder() {
        PlaceholderHelper.withPlayer("ender", DisplayHelper::createEnderDisplayText);
    }

    private static void registerDisplayInvPlaceholder() {
        PlaceholderHelper.withPlayer("inv", DisplayHelper::createInvDisplayText);
    }

    private static void registerDisplayItemPlaceholder() {
        PlaceholderHelper.withPlayer("item", DisplayHelper::createItemDisplayText);
    }

    @Override
    protected void registerPlaceholder() {
        ChatDisplayInitializer.registerDisplayItemPlaceholder();
        ChatDisplayInitializer.registerDisplayInvPlaceholder();
        ChatDisplayInitializer.registerDisplayEnderPlaceholder();
    }
}

