/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.display.helper;

import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.module.initializer.chat.display.ChatDisplayInitializer;
import io.github.sakurawald.module.initializer.chat.display.gui.BaseDisplayGui;
import io.github.sakurawald.module.initializer.chat.display.gui.EnderChestDisplayGui;
import io.github.sakurawald.module.initializer.chat.display.gui.InventoryDisplayGui;
import io.github.sakurawald.module.initializer.chat.display.gui.ItemDisplayGui;
import io.github.sakurawald.module.initializer.chat.display.gui.ShulkerBoxDisplayGui;
import io.github.sakurawald.module.initializer.chat.display.structure.SoftReferenceMap;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DisplayHelper {
    private static final SoftReferenceMap<String, BaseDisplayGui> uuid2gui = new SoftReferenceMap();

    private static String bindUUID(BaseDisplayGui displayGui) {
        String uuid = UUID.randomUUID().toString();
        uuid2gui.put(uuid, displayGui);
        return uuid;
    }

    private static void viewDisplayGui(@NotNull class_3222 viewerPlayer, String displayUUID) {
        BaseDisplayGui baseDisplayGui = uuid2gui.get(displayUUID);
        if (baseDisplayGui == null) {
            TextHelper.sendMessageByKey(viewerPlayer, "display.invalid", new Object[0]);
            return;
        }
        baseDisplayGui.build(viewerPlayer).open();
    }

    public static class_5250 createEnderDisplayText(class_3222 player) {
        String displayUUID = DisplayHelper.bindUUID(new EnderChestDisplayGui(player));
        return TextHelper.getTextByKey(player, "display.ender_chest.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(player, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    public static class_5250 createInvDisplayText(class_3222 player) {
        String displayUUID = DisplayHelper.bindUUID(new InventoryDisplayGui(player));
        return TextHelper.getTextByKey(player, "display.inventory.text", new Object[0]).method_27661().method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(player, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
    }

    @NotNull
    public static class_5250 createItemDisplayText(class_3222 player) {
        class_1799 itemStack = player.method_6047().method_7972();
        BaseDisplayGui displayGui = BaseDisplayGui.isShulkerBox(itemStack) ? new ShulkerBoxDisplayGui(player, itemStack, null) : new ItemDisplayGui(player, itemStack);
        String displayUUID = DisplayHelper.bindUUID(displayGui);
        class_5250 translatable = class_2561.method_43471((String)player.method_6047().method_7909().method_7876());
        translatable.method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction(TextHelper.getTextByKey(player, "display.click.prompt", new Object[0]))).method_10958(DisplayHelper.makeDisplayClickEvent(displayUUID)));
        class_5250 text = TextHelper.getTextByKey(player, "display.item.text", new Object[0]).method_27661();
        text = TextHelper.replaceTextWithMarker((class_2561)text, "item", () -> translatable);
        return text;
    }

    @NotNull
    private static class_2558 makeDisplayClickEvent(String displayUUID) {
        return Managers.getCallbackManager().makeCallbackEvent(player -> DisplayHelper.viewDisplayGui(player, displayUUID), ChatDisplayInitializer.config.model().expiration_duration_s, TimeUnit.SECONDS);
    }
}

