/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.chat.history;

import com.google.common.collect.EvictingQueue;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.chat.history.config.model.ChatHistoryConfigModel;
import java.util.Queue;
import net.minecraft.class_2561;

public class ChatHistoryInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<ChatHistoryConfigModel> config = new ObjectConfigurationHandler<ChatHistoryConfigModel>("config.json", ChatHistoryConfigModel.class);
    private static Queue<class_2561> chatHistory;

    @Override
    protected void onInitialize() {
        chatHistory = EvictingQueue.create((int)ChatHistoryInitializer.config.model().buffer_size);
    }

    public static boolean isMessageTypeFiltered(String messageTypeAsString) {
        LogUtil.debug("message type = {}", messageTypeAsString);
        boolean filtered = false;
        if (ChatHistoryInitializer.config.model().message_type_filters.stream().anyMatch(messageTypeAsString::equals)) {
            filtered = true;
        }
        if (!filtered) {
            LogUtil.debug("One filter EXCLUDES a message: message type = {}", messageTypeAsString);
        }
        return filtered;
    }

    public static boolean isMessageRejected(String contentString, String parametersString) {
        LogUtil.debug("content = {}, parameters = {}", contentString, parametersString);
        boolean rejected = false;
        if (ChatHistoryInitializer.config.model().message_rejectors.content_rejector.rules.stream().anyMatch(contentString::contains)) {
            rejected = true;
        }
        if (ChatHistoryInitializer.config.model().message_rejectors.parameter_rejector.rules.stream().anyMatch(parametersString::contains)) {
            rejected = true;
        }
        if (rejected) {
            LogUtil.debug("One rejector REJECTS a message: content = {}, parameters = {}", contentString, parametersString);
        }
        return rejected;
    }

    @Override
    protected void onReload() {
        EvictingQueue newQueue = EvictingQueue.create((int)ChatHistoryInitializer.config.model().buffer_size);
        newQueue.addAll(chatHistory);
        chatHistory.clear();
        chatHistory = newQueue;
    }

    public static Queue<class_2561> getChatHistory() {
        return chatHistory;
    }
}

