/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.cleaner;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.StackHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.structure.TypeFormatter;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.cleaner.config.model.CleanerConfigModel;
import io.github.sakurawald.module.initializer.cleaner.job.CleanerJob;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

@CommandNode(value="cleaner")
@CommandRequirement(level=4)
public class CleanerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CleanerConfigModel> config = new ObjectConfigurationHandler<CleanerConfigModel>("config.json", CleanerConfigModel.class);

    private static boolean ignoreEntity(class_1297 entity) {
        if (entity.method_5864().equals(class_1299.field_6097)) {
            return true;
        }
        if (EntityHelper.isBlockAttachedEntity(entity)) {
            return true;
        }
        if (EntityHelper.isVehicleEntity(entity)) {
            return true;
        }
        CleanerConfigModel.Ignore config = CleanerInitializer.config.model().ignore;
        if (config.ignore_item_entity && entity instanceof class_1542) {
            return true;
        }
        if (config.ignore_living_entity && entity.method_5709()) {
            return true;
        }
        if (config.ignore_named_entity) {
            class_1542 ie;
            class_1799 stack;
            if (entity.method_16914()) {
                return true;
            }
            if (entity instanceof class_1542 && StackHelper.hasCustomName(stack = (ie = (class_1542)entity).method_6983())) {
                return true;
            }
        }
        if (config.ignore_entity_with_vehicle && entity.method_5765()) {
            return true;
        }
        if (config.ignore_entity_with_passengers && entity.method_5782()) {
            return true;
        }
        if (config.ignore_glowing_entity && entity.method_5851()) {
            return true;
        }
        return config.ignore_leashed_entity && EntityHelper.isLeashed(entity);
    }

    private static boolean shouldRemove(String key, int age) {
        Map<String, Integer> regex2age = CleanerInitializer.config.model().key2age;
        return regex2age.containsKey(key) && age >= regex2age.get(key);
    }

    @CommandNode(value="clean")
    @Document(value="Trigger the cleaner manually.")
    public static int clean() {
        CompletableFuture.runAsync(() -> {
            HashMap<String, Integer> counter = new HashMap<String, Integer>();
            for (class_3218 world : ServerHelper.getServer().method_3738()) {
                for (class_1297 entity : world.method_27909()) {
                    String key;
                    if (CleanerInitializer.ignoreEntity(entity)) continue;
                    if (entity instanceof class_1542) {
                        class_1542 itemEntity = (class_1542)entity;
                        key = itemEntity.method_6983().method_7909().method_7876();
                    } else {
                        key = entity.method_5864().method_5882();
                    }
                    if (!CleanerInitializer.shouldRemove(key, entity.field_6012)) continue;
                    counter.put(key, counter.getOrDefault(key, 0) + 1);
                    entity.method_31472();
                }
            }
            CleanerInitializer.sendCleanerBroadcast(counter);
        });
        return 1;
    }

    private static void sendCleanerBroadcast(Map<String, Integer> counter) {
        if (counter.isEmpty()) {
            return;
        }
        LogUtil.info("Remove entities: {}", counter);
        class_5250 hoverText = class_2561.method_43473().method_27692(class_124.field_1065).method_10852(TypeFormatter.formatTypes(null, counter));
        for (class_3222 player : ServerHelper.getPlayers()) {
            class_5250 text = class_2561.method_43473().method_10852(TextHelper.getTextByKey(player, "cleaner.broadcast", counter.values().stream().mapToInt(Integer::intValue).sum())).method_27696(class_2583.field_24360.method_10949(TextHelper.HoverEvent.makeShowTextAction((class_2561)hoverText)));
            player.method_43496((class_2561)text);
        }
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> new CleanerJob().schedule());
    }
}

