/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_bundle;

import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.core.command.structure.CommandDescriptor;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.CommandEvents;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.gui.CommandDescriptorGui;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_bundle.config.model.CommandBundleConfigModel;
import io.github.sakurawald.module.initializer.command_bundle.structure.BundleCommandDescriptor;
import java.util.stream.Stream;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@CommandNode(value="command-bundle")
@CommandRequirement(level=4)
public class CommandBundleInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<CommandBundleConfigModel> config = new ObjectConfigurationHandler<CommandBundleConfigModel>("config.json", CommandBundleConfigModel.class);

    @CommandNode(value="register")
    @Document(value="Register all commands defined in bundle-command configuration file.")
    private static int registerAllBundleCommands() {
        LogUtil.info("Register bundle commands.", new Object[0]);
        config.model().getEntries().stream().map(BundleCommandDescriptor::make).forEach(it -> {
            LogUtil.info("Register bundle command: {}", it.getCommandSyntax());
            it.register();
        });
        CommandHelper.updateCommandTree();
        return 1;
    }

    @CommandNode(value="un-register")
    @Document(value="Un-register all bundle-commands registered in server.")
    private static int unregisterAllBundleCommands() {
        LogUtil.info("Un-register bundle commands.", new Object[0]);
        CommandAnnotationProcessor.descriptors.stream().filter(it -> it instanceof BundleCommandDescriptor).forEach(it -> {
            LogUtil.info("Un-register bundle command: {}", it.getCommandSyntax());
            it.unregister();
        });
        CommandHelper.updateCommandTree();
        return 1;
    }

    @CommandNode(value="list")
    @Document(value="List all registered bundle-commands in server.")
    private static int list(@CommandSource CommandContext<class_2168> ctx) {
        Stream<CommandDescriptor> commandDescriptorStream = CommandAnnotationProcessor.descriptors.stream().filter(it -> it instanceof BundleCommandDescriptor);
        if (((class_2168)ctx.getSource()).method_43737()) {
            new CommandDescriptorGui(((class_2168)ctx.getSource()).method_44023(), commandDescriptorStream.toList(), 0).open();
        } else {
            commandDescriptorStream.forEach(it -> ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)it.getCommandNodePath())));
        }
        return 1;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CommandBundleInitializer.registerAllBundleCommands();
            CommandEvents.REGISTRATION.register((a, b, c) -> CommandBundleInitializer.registerAllBundleCommands());
        });
    }

    @Override
    protected void onReload() {
        CommandBundleInitializer.unregisterAllBundleCommands();
        CommandBundleInitializer.registerAllBundleCommands();
    }
}

