/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.echo.send_custom;

import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.service.paged_text.PagedBookText;
import io.github.sakurawald.core.service.paged_text.PagedMessageText;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.echo.send_custom.command.argument.wrapper.CustomTextName;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@CommandNode(value="send-custom")
@CommandRequirement(level=4)
public class SendCustomInitializer
extends ModuleInitializer {
    public static final Path CUSTOM_TEXT_DIR_PATH = ReflectionUtil.computeModuleConfigPath(SendCustomInitializer.class).resolve("custom-text");

    private static String withCustomText(class_3222 player, CustomTextName name) {
        String value = (String)name.getValue();
        Path resolve = CUSTOM_TEXT_DIR_PATH.resolve(value);
        try {
            return Files.readString(resolve);
        }
        catch (IOException e) {
            TextHelper.sendMessageByKey(player, "echo.send_custom.custom_text.not_found", value);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="as-message")
    private static int asMessage(@CommandSource class_2168 source, class_3222 player, CustomTextName name) {
        String string = SendCustomInitializer.withCustomText(player, name);
        PagedMessageText pagedMessageText = new PagedMessageText(player, string);
        pagedMessageText.sendPage(player, 0);
        return 1;
    }

    @CommandNode(value="as-book")
    private static int asBook(@CommandSource class_2168 source, class_3222 player, CustomTextName customTextName, Optional<Boolean> openBook, Optional<Boolean> giveBook, Optional<String> title, Optional<String> author) {
        String string = SendCustomInitializer.withCustomText(player, customTextName);
        PagedBookText pagedText = new PagedBookText(player, string);
        BookElementBuilder bookElementBuilder = new BookElementBuilder();
        author.ifPresent(arg_0 -> ((BookElementBuilder)bookElementBuilder).setAuthor(arg_0));
        title.ifPresent(it -> bookElementBuilder.setName(TextHelper.getTextByValue(player, it, new Object[0])));
        pagedText.getPages().forEach(arg_0 -> ((BookElementBuilder)bookElementBuilder).addPage(arg_0));
        BookGui gui = new BookGui(player, bookElementBuilder){

            public void onTakeBookButton() {
                this.close();
            }
        };
        if (giveBook.orElse(true).booleanValue()) {
            class_1799 copy = gui.getBook().method_7972();
            player.method_7270(copy);
        }
        if (openBook.orElse(true).booleanValue()) {
            gui.open();
        }
        return 1;
    }

    @Override
    protected void onInitialize() {
        Files.createDirectories(CUSTOM_TEXT_DIR_PATH, new FileAttribute[0]);
    }
}

