/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.nametag;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.nametag.config.model.NametagConfigModel;
import io.github.sakurawald.module.initializer.nametag.job.UpdateNametagJob;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2716;
import net.minecraft.class_2739;
import net.minecraft.class_2752;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_4050;
import net.minecraft.class_8104;
import net.minecraft.class_8113;
import org.joml.Vector3f;

public class NametagInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<NametagConfigModel> config = new ObjectConfigurationHandler<NametagConfigModel>("config.json", NametagConfigModel.class);
    private static Map<class_3222, class_8113.class_8123> player2nametag;

    private static class_8113.class_8123 makeNametag(class_3222 player) {
        LogUtil.debug("Make nametag for player: {}", player.method_7334().getName());
        class_8113.class_8123 nametag = new class_8113.class_8123(class_1299.field_42457, (class_1937)EntityHelper.getServerWorld((class_1297)player)){

            private void discardNametag() {
                ServerHelper.sendPacketToAll(new class_2716(new int[]{this.method_5628()}));
                this.method_5650(class_1297.class_5529.field_26999);
            }

            public void method_5773() {
                super.method_5773();
                if (this.method_5854() == null) {
                    LogUtil.debug("Discard nametag entity {}: its vehicle is null", new Object[]{this});
                    this.discardNametag();
                    return;
                }
                String discardNametagReason = NametagInitializer.getNametagDiscardReason((class_1309)this.method_5854());
                if (discardNametagReason != null) {
                    LogUtil.debug("Discard nametag entity {}: {}", new Object[]{this, discardNametagReason});
                    this.discardNametag();
                }
            }
        };
        nametag.method_5684(true);
        NametagInitializer.letTheNametagRideThePlayer((class_1297)nametag, (class_1657)player);
        NametagInitializer.sendExistingNametagsToTheNewJoinedPlayer(player);
        NametagInitializer.broadcastTheNewNametagToAllPlayers(player, nametag);
        return nametag;
    }

    private static void letTheNametagRideThePlayer(class_1297 nametag, class_1657 player) {
        nametag.method_18380(class_4050.field_18076);
        nametag.field_6034 = player;
        nametag.field_6034.method_5627(nametag);
    }

    private static class_2338 computeNametagSpawnBlockPos(class_3222 bindingPlayer) {
        return bindingPlayer.method_24515().method_10069(0, 3, 0);
    }

    private static void sendExistingNametagsToTheNewJoinedPlayer(class_3222 player) {
        player2nametag.forEach((key, value) -> {
            class_2338 blockPos = NametagInitializer.computeNametagSpawnBlockPos(key);
            class_2604 entitySpawnS2CPacket = new class_2604((class_1297)value, 0, blockPos);
            player.field_13987.method_14364((class_2596)entitySpawnS2CPacket);
            class_2752 entityPassengersSetS2CPacket = new class_2752((class_1297)key);
            player.field_13987.method_14364((class_2596)entityPassengersSetS2CPacket);
            player.field_13987.method_14364((class_2596)new class_2739(value.method_5628(), value.method_5841().method_46357()));
        });
    }

    private static void broadcastTheNewNametagToAllPlayers(class_3222 player, class_8113.class_8123 textDisplayEntity) {
        class_2338 blockPos = NametagInitializer.computeNametagSpawnBlockPos(player);
        class_2604 entitySpawnS2CPacket = new class_2604((class_1297)textDisplayEntity, 0, blockPos);
        ServerHelper.sendPacketToAll(entitySpawnS2CPacket);
        class_2752 entityPassengersSetS2CPacket = new class_2752((class_1297)player);
        ServerHelper.sendPacketToAll(entityPassengersSetS2CPacket);
    }

    private static byte setTextDisplayFlags(int base, int flag, boolean value) {
        return (byte)(value ? base | flag : base & ~flag);
    }

    private static void setDisplayFlag(class_2945 dataTracker, byte flag, boolean value) {
        Byte original = (Byte)dataTracker.method_12789(class_8113.class_8123.field_42439);
        dataTracker.method_12778(class_8113.class_8123.field_42439, (Object)NametagInitializer.setTextDisplayFlags(original.byteValue(), flag, value));
    }

    private static void renderNametag(class_8113.class_8123 nametag, class_3222 player) {
        List dirty;
        NametagConfigModel config = NametagInitializer.config.model();
        nametag.method_48847(class_8113.class_8114.field_42409);
        class_2561 text = TextHelper.getTextByValue(player, config.style.text, new Object[0]);
        nametag.method_48911(text);
        nametag.method_5841().method_12778(class_8113.field_42401, (Object)new Vector3f(config.style.offset.x, config.style.offset.y, config.style.offset.z));
        nametag.method_48873(config.style.size.width);
        nametag.method_48875(config.style.size.height);
        nametag.method_48910(config.style.color.background);
        nametag.method_48909(config.style.color.text_opacity);
        nametag.method_5841().method_12778(class_8113.field_42402, (Object)new Vector3f(config.style.scale.x, config.style.scale.y, config.style.scale.z));
        NametagInitializer.setDisplayFlag(nametag.method_5841(), (byte)1, config.style.shadow.shadow);
        nametag.method_48862(config.style.shadow.shadow_radius);
        nametag.method_48872(config.style.shadow.shadow_strength);
        NametagInitializer.setDisplayFlag(nametag.method_5841(), (byte)2, config.render.see_through_blocks);
        nametag.method_48861(config.render.view_range);
        if (config.style.brightness.override_brightness) {
            nametag.method_48846(new class_8104(config.style.brightness.block, config.style.brightness.sky));
        }
        if (nametag.method_5841().method_12786() && (dirty = nametag.method_5841().method_12781()) != null) {
            int entityId = nametag.method_5628();
            ServerHelper.sendPacketToAll(new class_2739(entityId, dirty));
        }
    }

    private static String getNametagDiscardReason(class_1309 entity) {
        if (entity.method_29504()) {
            return "The entity is dead.";
        }
        if (entity.method_5715()) {
            return "The entity is sneaking.";
        }
        if (entity.method_35049() != null) {
            return "The entity is removed.";
        }
        if (entity.method_5767()) {
            return "The entity is invisible.";
        }
        return null;
    }

    public static void processNametagsForOnlinePlayers() {
        player2nametag.values().forEach(class_8113::method_5773);
        player2nametag.entrySet().removeIf(entry -> ((class_3222)entry.getKey()).method_31481() || ((class_8113.class_8123)entry.getValue()).method_31481());
        ServerHelper.getPlayers().forEach(player -> {
            if (NametagInitializer.getNametagDiscardReason((class_1309)player) != null) {
                return;
            }
            if (!player2nametag.containsKey(player)) {
                player2nametag.put((class_3222)player, NametagInitializer.makeNametag(player));
            }
            class_8113.class_8123 nametag = player2nametag.get(player);
            NametagInitializer.renderNametag(nametag, player);
        });
    }

    @Override
    protected void onInitialize() {
        player2nametag = new ConcurrentHashMap<class_3222, class_8113.class_8123>();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> new UpdateNametagJob().schedule());
    }

    @Override
    protected void onReload() {
        LogUtil.debug("Discard all the nametags. (The module is reloaded)", new Object[0]);
        player2nametag.forEach((key, value) -> value.method_5848());
    }
}

