/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.sit;

import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.annotation.CommandTarget;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.sit.config.model.SitConfigModel;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/BradBot1/FabricSit"})
public class SitInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<SitConfigModel> config = new ObjectConfigurationHandler<SitConfigModel>("config.json", SitConfigModel.class);
    private static final class_243 CHAIR_ENTITY_OFFSET = new class_243(0.0, -1.375, 0.0);
    private static final Set<class_1297> SPAWNED_CHAIR_ENTITY_LIST = new HashSet<class_1297>();

    public static boolean canSitNow(class_3222 player) {
        return player.method_24828() && !player.method_5765() && !player.method_6113() && !player.method_5681() && !player.method_7325();
    }

    @CommandNode(value="sit")
    @Document(value="Sit in current position.")
    private static int $sit(@CommandSource @CommandTarget class_3222 player) {
        class_2338 steppingBlockPos = player.method_23312();
        class_2680 steppingBlockState = player.method_37908().method_8320(steppingBlockPos);
        if (!SitInitializer.canSitNow(player) || steppingBlockState.method_26215() || steppingBlockState.method_51176()) {
            TextHelper.sendActionBarByKey(player, "sit.fail", new Object[0]);
            return -1;
        }
        class_243 lookTarget = player.method_19538().method_1031(0.5, 0.0, 0.5);
        class_1297 chairEntity = SitInitializer.spawnChairEntity(player.method_37908(), steppingBlockPos, lookTarget);
        SPAWNED_CHAIR_ENTITY_LIST.add(chairEntity);
        player.method_5873(chairEntity, true);
        return 1;
    }

    private static double computeSensibleLengthY(class_265 voxelShape) {
        double averageLengthY = voxelShape.method_1090().stream().mapToDouble(it -> it.method_17940()).average().orElse(0.0);
        return averageLengthY;
    }

    @NotNull
    public static class_1297 spawnChairEntity(@NotNull class_1937 world, final @NotNull class_2338 targetBlockPos, @Nullable class_243 lookingTarget) {
        class_243 chairEntityPosition = WorldHelper.toBottomCenterPos(targetBlockPos).method_1031(0.0, 0.5, 0.0).method_1019(CHAIR_ENTITY_OFFSET);
        class_2680 targetBlockState = world.method_8320(targetBlockPos);
        class_265 outlineShape = targetBlockState.method_26218((class_1922)world, targetBlockPos);
        final double averageLengthY = SitInitializer.computeSensibleLengthY(outlineShape);
        if (!class_2248.method_9501((class_265)outlineShape, (class_2350)class_2350.field_11036)) {
            chairEntityPosition = chairEntityPosition.method_1031(0.0, -(1.0 - averageLengthY), 0.0);
        }
        class_1531 chairEntity = new class_1531(world, chairEntityPosition.field_1352, chairEntityPosition.field_1351, chairEntityPosition.field_1350){
            private boolean hasPassenger;
            private class_243 dismountOffset;
            {
                super(world, d, e, f);
                this.hasPassenger = false;
                this.dismountOffset = new class_243(0.0, averageLengthY, 0.0);
            }

            public void method_5627(class_1297 passenger) {
                super.method_5627(passenger);
                this.hasPassenger = true;
            }

            public boolean method_6034() {
                return false;
            }

            public boolean method_30632(class_2338 blockPos, class_2680 blockState) {
                return false;
            }

            public class_2338 getChairBlockPos() {
                return targetBlockPos;
            }

            public boolean isChairBlockBroken() {
                return EntityHelper.getServerWorld((class_1297)this).method_8320(this.getChairBlockPos()).method_26215();
            }

            public class_243 getDismountPosition() {
                return this.getChairBlockPos().method_46558().method_1019(this.dismountOffset);
            }

            public class_243 method_24829(class_1309 livingEntity) {
                return this.getDismountPosition();
            }

            protected void method_5793(class_1297 entity) {
                super.method_5793(entity);
                if (this.isChairBlockBroken()) {
                    class_243 dismountPosition = this.getDismountPosition();
                    entity.method_5808(dismountPosition.field_1352, dismountPosition.field_1351, dismountPosition.field_1350, entity.method_36454(), entity.method_36455());
                    EntityHelper.killEntity((class_1297)this);
                }
            }

            public void method_5773() {
                class_1297 passenger;
                if (this.hasPassenger && this.method_5685().isEmpty()) {
                    EntityHelper.killEntity((class_1297)this);
                }
                if (this.isChairBlockBroken()) {
                    EntityHelper.killEntity((class_1297)this);
                }
                if ((passenger = this.method_31483()) != null) {
                    this.method_36456(passenger.method_36454());
                    this.method_36457(passenger.method_36455());
                }
                super.method_5773();
            }
        };
        if (lookingTarget != null) {
            chairEntity.method_5702(class_2183.class_2184.field_9851, lookingTarget.method_1023(0.0, lookingTarget.method_10214() * 2.0, 0.0));
        }
        chairEntity.method_5648(true);
        chairEntity.method_5684(true);
        chairEntity.method_5665((class_2561)class_2561.method_43470((String)"FUJI-SIT"));
        chairEntity.method_5875(true);
        world.method_8649((class_1297)chairEntity);
        return chairEntity;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> SPAWNED_CHAIR_ENTITY_LIST.forEach(entity -> {
            if (entity.method_5805()) {
                EntityHelper.killEntity(entity);
            }
        }));
    }
}

