/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.works.structure.work.impl;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.ConfirmGui;
import io.github.sakurawald.core.gui.InputSignGui;
import io.github.sakurawald.module.initializer.works.WorksInitializer;
import io.github.sakurawald.module.initializer.works.structure.WorksBinding;
import io.github.sakurawald.module.initializer.works.structure.work.abst.Work;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1700;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_2818;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;

public class ProductionWork
extends Work {
    @NotNull
    public Sample sample = new Sample();

    public ProductionWork(@NotNull class_3222 player, String name) {
        super(player, name);
    }

    @Override
    @NotNull
    protected String getType() {
        return Work.WorkType.ProductionWork.name();
    }

    @NotNull
    private List<class_2561> formatSampleCounter(class_3222 player) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        long currentTimeMS = System.currentTimeMillis();
        Stream sortedStream = this.sample.sampleCounter.entrySet().stream().sorted((entry1, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry1.getValue()));
        sortedStream.forEach(entry -> {
            String key = (String)entry.getKey();
            double rate = (double)((Long)entry.getValue()).longValue() * (3600000.0 / (double)(Math.min(this.sample.sampleEndTimeMS, currentTimeMS) - this.sample.sampleStartTimeMS));
            class_2561 text = TextHelper.getTextByKey(player, "works.production_work.prop.sample_counter.entry", entry.getValue(), rate);
            text = TextHelper.replaceTextWithMarker(text, "item", () -> class_2561.method_43471((String)key));
            ret.add(text);
        });
        if (ret.isEmpty()) {
            ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_counter.empty", new Object[0]));
        }
        return ret;
    }

    @Override
    @NotNull
    public List<class_2561> asLore(class_3222 player) {
        List<class_2561> ret = super.asLore(player);
        if (this.sample.sampleStartTimeMS == 0L) {
            ret.addAll(TextHelper.getTextListByKey(player, "works.production_work.sample.not_exists"));
            return ret;
        }
        ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_start_time", ChronosUtil.toStandardDateFormat(this.sample.sampleStartTimeMS)));
        ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_end_time", ChronosUtil.toStandardDateFormat(this.sample.sampleEndTimeMS)));
        ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_dimension", this.sample.sampleDimension));
        ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_coordinate", this.sample.sampleX, this.sample.sampleY, this.sample.sampleZ));
        ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_distance", this.sample.sampleDistance));
        if (this.sample.sampleCounter != null) {
            if (this.sample.sampleCounter.size() > WorksInitializer.config.model().sample_counter_top_n) {
                this.trimCounter();
            }
            ret.add(TextHelper.getTextByKey(player, "works.production_work.prop.sample_counter", new Object[0]));
            ret.addAll(this.formatSampleCounter(player));
        }
        return ret;
    }

    @Override
    @NotNull
    protected String getDefaultIconItemIdentifier() {
        return "minecraft:redstone";
    }

    public void openInputSampleDistanceGui(@NotNull class_3222 player) {
        new InputSignGui(player, TextHelper.getTextByKey(player, "works.production_work.prompt.input.sample_distance", new Object[0])){

            public void onClose() {
                int current;
                int limit = WorksInitializer.config.model().sample_distance_limit;
                try {
                    current = Integer.parseInt(this.getLine(0).getString());
                }
                catch (NumberFormatException e) {
                    TextHelper.sendActionBarByKey(this.player, "input.syntax.error", new Object[0]);
                    return;
                }
                if (current > limit) {
                    TextHelper.sendActionBarByKey(this.player, "input.limit.error", new Object[0]);
                    return;
                }
                ProductionWork.this.sample.sampleDistance = current;
                if (ProductionWork.this.isSampling()) {
                    ProductionWork.this.endSample();
                }
                ProductionWork.this.startSample(this.player);
            }
        }.open();
    }

    @Override
    public void openSpecializedSettingsGui(class_3222 player, @NotNull SimpleGui parentGui) {
        SimpleGui gui = new SimpleGui(class_3917.field_18664, player, false);
        gui.setTitle(TextHelper.getTextByKey(player, "works.work.set.specialized_settings.title", new Object[0]));
        gui.setLockPlayerInventory(true);
        gui.addSlot(new GuiElementBuilder().setItem(class_1802.field_8557).setName(TextHelper.getTextByKey(player, "works.production_work.set.sample", new Object[0])).setLore(TextHelper.getTextListByKey(player, "works.production_work.set.sample.lore")).setCallback(() -> new ConfirmGui(player){

            @Override
            public void onConfirm() {
                ProductionWork.this.openInputSampleDistanceGui(this.player);
            }
        }.open()));
        gui.setSlot(8, GuiHelper.makeBackButton(player).setCallback(() -> ((SimpleGui)parentGui).open()));
        gui.open();
    }

    private boolean isSampling() {
        return System.currentTimeMillis() < this.sample.sampleEndTimeMS;
    }

    @Override
    public class_1792 getIconItem() {
        return super.getIconItem();
    }

    private boolean insideSampleDistance(@NotNull class_2338 position, @NotNull class_2338 blockPos) {
        float deltaX = Math.abs(blockPos.method_10263() - position.method_10263());
        float deltaZ = Math.abs(blockPos.method_10260() - position.method_10260());
        return deltaX <= (float)this.sample.sampleDistance && deltaZ <= (float)this.sample.sampleDistance;
    }

    @NotNull
    private String formatBlockPosList(@NotNull ArrayList<class_2338> blockPosList) {
        StringBuilder sb = new StringBuilder();
        for (class_2338 blockPos : blockPosList) {
            sb.append("(").append(blockPos.method_10263()).append(",").append(blockPos.method_10264()).append(",").append(blockPos.method_10260()).append(")").append(" ");
        }
        return sb.toString();
    }

    private int resolveHoppers(@NotNull class_3222 player) {
        WorksBinding.unbind(this);
        int hopperBlockCount = 0;
        int minecartHopperCount = 0;
        class_3218 world = EntityHelper.getServerWorld((class_1297)player);
        Iterable chunkHolders = world.method_14178().field_17254.method_17264();
        for (class_3193 chunkHolder : chunkHolders) {
            class_2818 worldChunk = chunkHolder.method_16144();
            if (worldChunk == null) continue;
            for (class_2586 blockEntity : worldChunk.method_12214().values()) {
                if (!(blockEntity instanceof class_2614) || !this.insideSampleDistance(player.method_24515(), blockEntity.method_11016())) continue;
                WorksBinding.bind(blockEntity.method_11016(), (Work)this);
                ++hopperBlockCount;
            }
        }
        for (class_1297 entity : world.method_27909()) {
            if (!(entity instanceof class_1700) || !this.insideSampleDistance(player.method_24515(), entity.method_24515())) continue;
            WorksBinding.bind(entity.method_5628(), (Work)this);
            ++minecartHopperCount;
        }
        TextHelper.sendMessageByKey(player, "works.production_work.sample.resolve_hoppers.response", hopperBlockCount, minecartHopperCount);
        return hopperBlockCount + minecartHopperCount;
    }

    @Override
    public void onSchedule() {
        if (System.currentTimeMillis() >= this.sample.sampleEndTimeMS) {
            this.endSample();
        }
    }

    private void startSample(@NotNull class_3222 player) {
        this.sample.sampleStartTimeMS = System.currentTimeMillis();
        this.sample.sampleEndTimeMS = this.sample.sampleStartTimeMS + (long)WorksInitializer.config.model().sample_time_ms;
        this.sample.sampleDimension = EntityHelper.getServerWorld((class_1297)player).method_27983().method_29177().toString();
        this.sample.sampleX = player.method_23317();
        this.sample.sampleY = player.method_23318();
        this.sample.sampleZ = player.method_23321();
        this.sample.sampleCounter = new HashMap();
        if (this.resolveHoppers(player) == 0) {
            TextHelper.sendMessageByKey(player, "operation.cancelled", new Object[0]);
            return;
        }
        TextHelper.sendBroadcastByKey("works.production_work.sample.start", this.name, this.creator);
    }

    private void endSample() {
        WorksBinding.unbind(this);
        TextHelper.sendBroadcastByKey("works.production_work.sample.end", this.name, this.creator);
        this.trimCounter();
    }

    private void trimCounter() {
        List sortedEntries = this.sample.sampleCounter.entrySet().stream().sorted((entry1, entry2) -> ((Long)entry2.getValue()).compareTo((Long)entry1.getValue())).toList();
        int N = WorksInitializer.config.model().sample_counter_top_n;
        this.sample.sampleCounter.clear();
        for (int i = 0; i < N && i < sortedEntries.size(); ++i) {
            this.sample.sampleCounter.put((String)((Map.Entry)sortedEntries.get(i)).getKey(), (Long)((Map.Entry)sortedEntries.get(i)).getValue());
        }
    }

    public void addCounter(@NotNull class_1799 itemStack) {
        HashMap<String, Long> counter = this.sample.sampleCounter;
        String key = itemStack.method_7909().method_7876();
        counter.put(key, counter.getOrDefault(key, 0L) + (long)itemStack.method_7947());
    }

    public ProductionWork() {
    }

    public static class Sample {
        public String sampleDimension;
        public double sampleX;
        public double sampleY;
        public double sampleZ;
        public long sampleStartTimeMS;
        public long sampleEndTimeMS;
        public int sampleDistance;
        public HashMap<String, Long> sampleCounter;
    }
}

