/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.system_message;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.module.initializer.system_message.SystemMessageInitializer;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2561.class})
public interface TextMixin {
    @Inject(method={"translatable(Ljava/lang/String;[Ljava/lang/Object;)Lnet/minecraft/text/MutableText;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void hijackTranslatableText(String key, Object[] args, @NotNull CallbackInfoReturnable<class_5250> cir) {
        class_5250 newValue = TextMixin.transform(key, args);
        if (newValue != null) {
            cir.setReturnValue((Object)newValue);
        }
    }

    @Inject(method={"translatable(Ljava/lang/String;)Lnet/minecraft/text/MutableText;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void hijackTranslatableText(String key, @NotNull CallbackInfoReturnable<class_5250> cir) {
        class_5250 newValue = TextMixin.transform(key, new Object[0]);
        if (newValue != null) {
            cir.setReturnValue((Object)newValue);
        }
    }

    @Unique
    @Nullable
    private static class_5250 transform(String key, Object ... args) {
        Map<String, String> key2value = SystemMessageInitializer.config.model().key2value;
        if (key2value.containsKey(key)) {
            if (ServerHelper.getServer() == null) {
                LogUtil.warn("Server is null currently -> cannot hijack the text with the key: {}", key);
                return null;
            }
            String value = key2value.get(key);
            if (value == null) {
                return null;
            }
            String textString = class_5250.method_43477((class_7417)new class_2588("force_fallback", value, args)).getString();
            return TextHelper.getTextByValue(null, textString, new Object[0]).method_27661();
        }
        return null;
    }
}

