/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.deathlog.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.List;
import mod.fuji.core.auxiliary.StringUtil;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.deathlog.gui.DeathNodeDisplayGuiFactory;
import mod.fuji.module.initializer.deathlog.structure.DeathNode;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeathNodeListGui
extends PagedGui<DeathNode> {
    private final String deadPlayerName;

    public DeathNodeListGui(@Nullable SimpleGui parent, class_3222 player, String deadPlayerName, @NotNull List<DeathNode> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "deathlog.death_node.list.gui.title", deadPlayerName), entities, pageIndex);
        this.deadPlayerName = deadPlayerName;
    }

    @Override
    @NotNull
    protected PagedGui<DeathNode> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<DeathNode> entities, int pageIndex) {
        return new DeathNodeListGui(parent, player, this.deadPlayerName, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull DeathNode entity) {
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8106).setName(class_2561.method_30163((String)entity.time)).setLore(entity.getLore(this.getPlayer())).setCallback(() -> this.openDeathNodeDisplayGui(entity))).build();
    }

    private void openDeathNodeDisplayGui(DeathNode entity) {
        new DeathNodeDisplayGuiFactory(this.getBackendGui(), entity).build(this.getPlayer()).open();
    }

    @Override
    protected boolean filterEntity(@NotNull DeathNode entity, @NotNull String keyword) {
        return entity.dimension.contains(keyword) || entity.time.contains(keyword) || StringUtil.containsIgnoreCase(entity.reason, keyword) || StringUtil.containsIgnoreCase(entity.main.toString(), keyword) || StringUtil.containsIgnoreCase(entity.armor.toString(), keyword) || StringUtil.containsIgnoreCase(entity.offhand.toString(), keyword);
    }
}

