/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.formatter;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import org.jetbrains.annotations.NotNull;

public class MarkdownDocumentFormatter {
    @NotNull
    public static String parseDocumentString(@NotNull String documentString) {
        Object result = MarkdownDocumentFormatter.parseTags(documentString);
        result = MarkdownDocumentFormatter.parseMarkdownSeparator((String)result);
        result = MarkdownDocumentFormatter.indentTwoSpacesPerLine((String)result);
        result = (String)result + "\n\n";
        return result;
    }

    @NotNull
    private static String parseTags(@NotNull String input) {
        return Arrays.stream(input.split("\n")).map(MarkdownDocumentFormatter::parseTagsInline).collect(Collectors.joining("\n"));
    }

    @NotNull
    private static String parseTagsInline(@NotNull String input) {
        String output = input;
        for (String namedColor : TextHelper.Formatter.NAMED_STYLE_TAGS) {
            output = output.replaceAll("<\\/?" + namedColor + ">", "");
        }
        output = output.replaceAll("<\\/?#[a-zA-Z0-9_]+>", "");
        output = MarkdownDocumentFormatter.unescapeTagsWithinInlineCodeFence(output);
        return output;
    }

    @NotNull
    private static String unescapeTagsWithinInlineCodeFence(@NotNull String input) {
        Pattern codePattern = Pattern.compile("`([^`]+)`");
        Matcher matcher = codePattern.matcher(input);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String codeBlock = matcher.group(1);
            String unescaped = codeBlock.replaceAll("\\\\([<>])", "$1");
            matcher.appendReplacement(result, "`" + Matcher.quoteReplacement(unescaped) + "`");
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @NotNull
    private static String parseMarkdownSeparator(@NotNull String input) {
        return input.replaceAll("\n", "\n\n");
    }

    private static String indentTwoSpacesPerLine(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return Arrays.stream(input.split("\n", -1)).map(line -> "  " + line).collect(Collectors.joining("\n"));
    }
}

