/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.config.mapper.adapter;

import com.google.errorprone.annotations.CheckReturnValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import lombok.Generated;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.config.mapper.GsonMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckedEnumTypeValueAdapter<T>
extends TypeAdapter<T> {
    private final TypeToken<T> typeToken;
    private final TypeAdapter<T> delegate;

    public void write(JsonWriter out, T value) throws IOException {
        this.delegate.write(out, value);
    }

    public T read(JsonReader in) throws IOException {
        Class concreteEnumClass = this.typeToken.getRawType();
        if (!GsonMapper.isNullableType(concreteEnumClass) && in.peek() == JsonToken.NULL) {
            throw this.handleInvalidEnumValueException(in, concreteEnumClass, null);
        }
        if (in.peek() == JsonToken.NULL) {
            @Nullable Object readInNullToken = this.delegate.read(in);
            return (T)readInNullToken;
        }
        String nextString = in.nextString();
        JsonPrimitive nextStringJsonElement = new JsonPrimitive(nextString);
        @Nullable Object read = this.delegate.fromJsonTree((JsonElement)nextStringJsonElement);
        if (read == null) {
            throw this.handleInvalidEnumValueException(in, concreteEnumClass, nextString);
        }
        return (T)read;
    }

    @CheckReturnValue
    private IllegalArgumentException handleInvalidEnumValueException(@NotNull JsonReader in, @NotNull Class<?> concreteEnumClass, @Nullable String inputJsnoString) {
        LogUtil.error("\n\n[Enum value is invalid]\nThe enum value of type '{}' is invalid.\n\n\u25c9 Json Path: {}\n\u25c9 Current enum value: {}\n\u25c9 Acceptable enum values: {}\n", concreteEnumClass.getName(), in.getPath(), inputJsnoString, ReflectionUtil.getEnumValuesCompactString(concreteEnumClass));
        return new IllegalArgumentException("Invalid enum value detected.");
    }

    @Generated
    public CheckedEnumTypeValueAdapter(TypeToken<T> typeToken, TypeAdapter<T> delegate) {
        this.typeToken = typeToken;
        this.delegate = delegate;
    }
}

