/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.document.inspector.FailedToInspectException;
import mod.fuji.core.document.inspector.InspectingObject;
import mod.fuji.core.document.inspector.JavaObjectInspector;
import mod.fuji.core.gui.component.gui.PagedGui;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaObjectInspectionGui
extends PagedGui<InspectingObject> {
    @NotNull
    private final String fileRelativePath;
    @NotNull
    private final JavaObjectInspector inspector;

    public JavaObjectInspectionGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<InspectingObject> entities, int pageIndex, @NotNull String fileRelativePath, @NotNull JavaObjectInspector inspector) {
        super(parent, player, TextHelper.getTextByKey(player, "object.gui.title", inspector.getWalkingPath()), entities, pageIndex);
        this.fileRelativePath = fileRelativePath;
        this.inspector = inspector;
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setItem(class_1802.field_17535).setLore(List.of(TextHelper.getTextByKey(player, "object.top_level", fileRelativePath), TextHelper.getTextByKey(player, "object.path", inspector.getWalkingPath()), TextHelper.getTextByKey(player, "object.type", inspector.getParentInspectingObject().getObjectTypeString()))));
    }

    @Override
    @NotNull
    protected PagedGui<InspectingObject> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<InspectingObject> entities, int pageIndex) {
        return new JavaObjectInspectionGui(parent, player, entities, pageIndex, this.fileRelativePath, this.inspector);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull InspectingObject entity) {
        GuiElementBuilder guiElementBuilder = (GuiElementBuilder)new GuiElementBuilder().setName(entity.toNameText(this.getPlayer())).setItem(GuiHelper.Material.fromObjectType(entity.getObjectValue(), entity.getObjectType())).setLore(entity.toLore(this.getPlayer())).setCallback(() -> this.openChildInspectorGui(entity));
        return guiElementBuilder.build();
    }

    private void openChildInspectorGui(@NotNull InspectingObject inspectingObject) {
        try {
            JavaObjectInspector childInspector = this.inspector.withChild(inspectingObject);
            new JavaObjectInspectionGui(this.getBackendGui(), this.getPlayer(), childInspector.getChildInspectingObjects(), 0, this.fileRelativePath, childInspector).open();
        }
        catch (FailedToInspectException failedToInspectException) {
            // empty catch block
        }
    }
}

