/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.document.inspector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import mod.fuji.core.auxiliary.StringUtil;
import mod.fuji.core.document.inspector.FailedToInspectException;
import mod.fuji.core.document.inspector.InspectingObject;
import org.jetbrains.annotations.NotNull;

public class JavaObjectInspector {
    private static final String WALKING_PATH_DELIMITER = ".";
    private final Optional<JavaObjectInspector> parent;
    @NotNull
    private final String walkingPath;
    @NotNull
    private final InspectingObject parentInspectingObject;
    @NotNull
    private final List<InspectingObject> childInspectingObjects;

    @NotNull
    public static JavaObjectInspector ofRoot(@NotNull Object object) throws FailedToInspectException {
        @NotNull InspectingObject root = InspectingObject.ofRoot(object);
        @NotNull List<InspectingObject> children = InspectingObject.inspect(root);
        return new JavaObjectInspector(Optional.empty(), WALKING_PATH_DELIMITER, root, children);
    }

    @NotNull
    public JavaObjectInspector withChild(@NotNull InspectingObject inspectingObject) throws FailedToInspectException {
        List<InspectingObject> childInspectingObjects = InspectingObject.inspect(inspectingObject);
        Optional<JavaObjectInspector> parentInspector = Optional.of(this);
        String childObjectName = inspectingObject.getObjectName();
        Object childWalkingPath = this.getWalkingPath() + WALKING_PATH_DELIMITER + childObjectName;
        childWalkingPath = StringUtil.trimPathString((String)childWalkingPath);
        return new JavaObjectInspector(parentInspector, (String)childWalkingPath, inspectingObject, childInspectingObjects);
    }

    @NotNull
    public List<InspectingObject> flatten() {
        ArrayList<InspectingObject> collector = new ArrayList<InspectingObject>();
        this.flattenRecursively(collector, this.getParentInspectingObject());
        return collector;
    }

    private void flattenRecursively(@NotNull List<InspectingObject> collector, @NotNull InspectingObject parentInspectingObject) {
        InspectingObject.inspect(parentInspectingObject).forEach(it -> {
            try {
                this.flattenRecursively(collector, (InspectingObject)it);
            }
            catch (FailedToInspectException failedToInspectException) {
                // empty catch block
            }
        });
        collector.add(parentInspectingObject);
    }

    @Generated
    public JavaObjectInspector(Optional<JavaObjectInspector> parent, @NotNull String walkingPath, @NotNull InspectingObject parentInspectingObject, @NotNull List<InspectingObject> childInspectingObjects) {
        if (walkingPath == null) {
            throw new NullPointerException("walkingPath is marked non-null but is null");
        }
        if (parentInspectingObject == null) {
            throw new NullPointerException("parentInspectingObject is marked non-null but is null");
        }
        if (childInspectingObjects == null) {
            throw new NullPointerException("childInspectingObjects is marked non-null but is null");
        }
        this.parent = parent;
        this.walkingPath = walkingPath;
        this.parentInspectingObject = parentInspectingObject;
        this.childInspectingObjects = childInspectingObjects;
    }

    @Generated
    public Optional<JavaObjectInspector> getParent() {
        return this.parent;
    }

    @NotNull
    @Generated
    public String getWalkingPath() {
        return this.walkingPath;
    }

    @NotNull
    @Generated
    public InspectingObject getParentInspectingObject() {
        return this.parentInspectingObject;
    }

    @NotNull
    @Generated
    public List<InspectingObject> getChildInspectingObjects() {
        return this.childInspectingObjects;
    }
}

