/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.structure;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import mod.fuji.core.auxiliary.AsyncUtil;
import mod.fuji.core.auxiliary.LogUtil;
import org.apache.commons.io.FileUtils;

public abstract class Downloader {
    private final URL url;
    private final Path destination;

    public Downloader(URL url, Path destination) {
        this.url = url;
        this.destination = destination;
    }

    public void startDownload() {
        AsyncUtil.runAsyncAndHandleExceptions(() -> {
            try {
                LogUtil.info("Start download file from {} to {}.", this.url, this.destination);
                FileUtils.copyURLToFile((URL)this.url, (File)this.destination.toFile());
                this.onComplete();
                LogUtil.info("End download file from {} to {}.", this.url, this.destination);
            }
            catch (IOException e) {
                LogUtil.error("Failed to download file from {} to {}", this.url, this.destination, e);
            }
        });
    }

    public abstract void onComplete();
}

