/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.kit.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.LogicHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.gui.component.gui.InputSignGui;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.kit.service.KitService;
import mod.fuji.module.initializer.kit.structure.Kit;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_747;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitEditorGui
extends PagedGui<Kit> {
    public KitEditorGui(class_3222 player, @NotNull List<Kit> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "kit.gui.editor.title", new Object[0]), entities, pageIndex);
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 1, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "kit.gui.editor.help.lore")));
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, (GuiElementBuilder)GuiHelper.Button.makeAddButton(player).setCallback(() -> new InputSignGui(player, TextHelper.getTextByKey(player, "prompt.input.name", new Object[0])){

            public void onClose() {
                String name = this.getLine(0).getString().trim();
                LogicHelper.withCancelCheck(this.player, name.isEmpty(), () -> KitEditorGui.this.openKitEditingGui(this.getPlayer(), KitService.readKit(name)));
            }
        }.open()));
    }

    public static KitEditorGui make(@NotNull class_3222 player) {
        List<Kit> kits = KitService.readKits();
        return new KitEditorGui(player, kits, 0);
    }

    private void openKitEditingGui(@NotNull class_3222 player, final @NotNull Kit kit) {
        int i2;
        int rows = 5;
        final class_1277 simpleInventory = new class_1277(rows * 9);
        for (i2 = 0; i2 < kit.getStackList().size(); ++i2) {
            simpleInventory.method_5447(i2, kit.getStackList().get(i2));
        }
        if (simpleInventory.method_5442()) {
            KitEditorGui.placeDefaultKitItems(simpleInventory);
        }
        for (i2 = 41; i2 <= 44; ++i2) {
            simpleInventory.method_5447(i2, GuiHelper.Validator.makeBannedSlotPlaceholder().getItemStack());
        }
        class_747 simpleNamedScreenHandlerFactory = new class_747((i, playerInventory, p) -> new class_1707(this, class_3917.field_18667, i, playerInventory, (class_1263)simpleInventory, rows){

            public void method_7593(int i, int j, class_1713 slotActionType, class_1657 playerEntity) {
                if (GuiHelper.Validator.isBannedSlotIndex((class_1703)this, i)) {
                    return;
                }
                super.method_7593(i, j, slotActionType, playerEntity);
            }

            public void method_7595(class_1657 playerEntity) {
                super.method_7595(playerEntity);
                ArrayList<class_1799> newStacks = new ArrayList<class_1799>();
                for (int j = 0; j < simpleInventory.method_5439(); ++j) {
                    newStacks.add(simpleInventory.method_5438(j));
                }
                KitService.createKit(kit.withStackList(newStacks));
            }
        }, TextHelper.getTextByKey(player, "kit.gui.editor.kit.title", kit.getName()));
        player.method_17355((class_3908)simpleNamedScreenHandlerFactory);
    }

    private static void placeDefaultKitItems(class_1277 simpleInventory) {
        simpleInventory.method_5447(0, class_1802.field_8371.method_7854());
        class_1799 food = class_1802.field_8229.method_7854();
        food.method_7939(16);
        simpleInventory.method_5447(1, food);
        simpleInventory.method_5447(36, class_1802.field_8660.method_7854());
        simpleInventory.method_5447(37, class_1802.field_8396.method_7854());
        simpleInventory.method_5447(38, class_1802.field_8523.method_7854());
        simpleInventory.method_5447(39, class_1802.field_8743.method_7854());
        simpleInventory.method_5447(40, class_1802.field_8255.method_7854());
    }

    @Override
    @NotNull
    protected PagedGui<Kit> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<Kit> entities, int pageIndex) {
        return new KitEditorGui(player, entities, pageIndex);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull Kit entity) {
        return ((GuiElementBuilder)new GuiElementBuilder().setItem(class_1802.field_8106).setName((class_2561)class_2561.method_43470((String)entity.getName())).setCallback(event -> {
            if (event.isLeft) {
                this.openKitEditingGui(this.getPlayer(), entity);
            }
            if (event.shift && event.isRight) {
                KitService.deleteKit(entity.getName());
                KitEditorGui.make(this.getPlayer()).open();
                TextHelper.sendTextByKey(this.getPlayer(), "deleted", new Object[0]);
            }
        })).build();
    }
}

