/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.document.inspector;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.inspector.FailedToInspectException;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectingObject {
    @NotNull
    private final Optional<Object> object;
    @NotNull
    private final Optional<Object> objectDeclaringClassInstance;
    @NotNull
    private final Optional<String> preferredObjectName;

    private InspectingObject(@NotNull Optional<Object> object, @NotNull Optional<Object> objectDeclaringClassInstance, @NotNull Optional<String> preferredObjectName) {
        this.object = object;
        this.objectDeclaringClassInstance = objectDeclaringClassInstance;
        this.preferredObjectName = preferredObjectName;
    }

    @NotNull
    public static InspectingObject ofRoot(@NotNull Object javaObject) {
        if (ReflectionUtil.isMetaClass(javaObject.getClass())) {
            throw new IllegalArgumentException("Cannot inspect object of type " + String.valueOf(javaObject.getClass()));
        }
        return InspectingObject.ofNonFieldObject(Optional.of(javaObject), Optional.empty());
    }

    @NotNull
    private static InspectingObject ofNonFieldObject(@NotNull Optional<Object> javaObject, @NotNull Optional<String> preferredObjectName) {
        return new InspectingObject(javaObject, Optional.empty(), preferredObjectName);
    }

    @NotNull
    private static InspectingObject ofFieldObject(@NotNull Optional<Object> javaObject, @NotNull Optional<Object> objectDeclaringClassInstance, @NotNull Optional<String> preferredObjectName) {
        return new InspectingObject(javaObject, objectDeclaringClassInstance, preferredObjectName);
    }

    @NotNull
    public Class<?> getObjectType() {
        return this.object.map($object -> {
            if ($object instanceof Field) {
                Field field = (Field)$object;
                return field.getType();
            }
            return $object.getClass();
        }).orElse(Void.class);
    }

    @NotNull
    public Optional<Object> getObjectValue() {
        return this.object.map($object -> {
            if ($object instanceof Field) {
                Field field = (Field)$object;
                return this.objectDeclaringClassInstance.map($objectDeclaringClassInstance -> {
                    try {
                        field.setAccessible(true);
                        @Nullable Object fieldValue = field.get($objectDeclaringClassInstance);
                        return fieldValue;
                    }
                    catch (Exception e) {
                        LogUtil.error("Failed to get the value of field {} in its declaring class instance {}.", field, $objectDeclaringClassInstance, e);
                        return null;
                    }
                }).orElse(null);
            }
            return $object;
        });
    }

    @NotNull
    private String getObjectValueString() {
        @NotNull String valueString = this.getObjectValue().map($objectValue -> {
            if ($objectValue instanceof Collection) {
                Collection collection = (Collection)$objectValue;
                return "%d elements".formatted(collection.size());
            }
            if ($objectValue instanceof Map) {
                Map map = (Map)$objectValue;
                return "%d mappings".formatted(map.size());
            }
            if ($objectValue instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)$objectValue;
                String keyTypeString = entry.getKey().getClass().getSimpleName();
                String valueTypeString = entry.getValue().getClass().getSimpleName();
                return "mapper %s -> %s".formatted(keyTypeString, valueTypeString);
            }
            return String.valueOf($objectValue);
        }).orElse("null");
        valueString = TextHelper.Parsers.escapeTags(valueString);
        return valueString;
    }

    @NotNull
    public String getObjectName() {
        return this.preferredObjectName.orElseGet(() -> this.object.map($object -> {
            if ($object instanceof Field) {
                Field field = (Field)$object;
                return field.getName();
            }
            return "$" + $object.getClass().getSimpleName();
        }).orElse("null"));
    }

    @NotNull
    public static List<InspectingObject> inspect(@NotNull InspectingObject inspectingObject) throws FailedToInspectException {
        return inspectingObject.getObjectValue().map(objectToInspect -> {
            if (!InspectingObject.canInspect(inspectingObject.getObjectType())) {
                throw new FailedToInspectException("Target object is considered as an atom.");
            }
            if (Iterable.class.isAssignableFrom(objectToInspect.getClass())) {
                Iterator iterator = ((Iterable)objectToInspect).iterator();
                ArrayList<InspectingObject> result = new ArrayList<InspectingObject>();
                int i = 0;
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    String elementIndex = "[" + i + "]";
                    result.add(InspectingObject.ofNonFieldObject(Optional.ofNullable(element), Optional.of(elementIndex)));
                    ++i;
                }
                return result;
            }
            if (Map.class.isAssignableFrom(objectToInspect.getClass())) {
                return ((Map)objectToInspect).entrySet().stream().map(entry -> {
                    String jsonObjectKeyName = null;
                    if (String.class.isAssignableFrom(entry.getKey().getClass())) {
                        jsonObjectKeyName = "\"" + String.valueOf(entry.getKey()) + "\"";
                    }
                    return InspectingObject.ofNonFieldObject(Optional.of(entry), Optional.ofNullable(jsonObjectKeyName));
                }).toList();
            }
            if (Map.Entry.class.isAssignableFrom(objectToInspect.getClass())) {
                Map.Entry entry2 = (Map.Entry)objectToInspect;
                InspectingObject entryKeyObject = InspectingObject.ofNonFieldObject(Optional.ofNullable(entry2.getKey()), Optional.of("KEY"));
                InspectingObject entryValueObject = InspectingObject.ofNonFieldObject(Optional.ofNullable(entry2.getValue()), Optional.of("VALUE"));
                return List.of(entryKeyObject, entryValueObject);
            }
            Class<?> inspectingObjectClass = objectToInspect.getClass();
            return ReflectionUtil.Reflection.gatherDeclaredFields(inspectingObjectClass).stream().filter(field -> {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    return false;
                }
                return !Modifier.isTransient(modifiers);
            }).map(it -> InspectingObject.ofFieldObject(Optional.of(it), Optional.of(objectToInspect), Optional.empty())).toList();
        }).orElseThrow(() -> new FailedToInspectException("Target object is null"));
    }

    private static boolean canInspect(@NotNull Class<?> objectType) {
        if (objectType.isPrimitive()) {
            return false;
        }
        if (ReflectionUtil.isPrimitiveWrapperType(objectType)) {
            return false;
        }
        if (objectType.equals(String.class)) {
            return false;
        }
        if (objectType.isArray()) {
            return false;
        }
        if (objectType.isEnum()) {
            return false;
        }
        if (objectType.isAnnotation()) {
            return false;
        }
        return !ReflectionUtil.isMetaClass(objectType);
    }

    @NotNull
    public class_2561 toNameText(@NotNull class_3222 player) {
        @NotNull String objectName = this.getObjectName();
        objectName = TextHelper.Parsers.escapeTags(objectName);
        return TextHelper.getTextByKey(player, "object.name", objectName);
    }

    private void addPossibleValuesForEnumType(@NotNull class_3222 player, @NotNull List<class_2561> lore) {
        if (!this.getObjectType().isEnum()) {
            return;
        }
        @NotNull String possibleValues = ReflectionUtil.getEnumValuesCompactString(this.getObjectType());
        lore.add(TextHelper.getTextByKey(player, "object.value.possible_values", possibleValues));
    }

    @NotNull
    public List<class_2561> toLore(@NotNull class_3222 player) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        String objectTypeString = this.getObjectTypeString();
        lore.add(TextHelper.getTextByKey(player, "object.type", objectTypeString));
        String objectValueString = this.getAbbreviatedObjectValueString();
        lore.add(TextHelper.getText(TextHelper.Parsers.STYLE_ONLY_PARSER, player, true, "object.value", objectValueString));
        this.addPossibleValuesForEnumType(player, lore);
        if (InspectingObject.canInspect(this.getObjectType())) {
            lore.add(TextHelper.getTextByKey(player, "prompt.click.see_inside", new Object[0]));
        }
        DocumentUtil.getAboveElementDocumentString(this.object, this.getObjectType(), player).ifPresent(documentString -> {
            lore.add(TextHelper.TEXT_EMPTY);
            lore.addAll(TextHelper.getDocumentTextList(player, documentString));
        });
        return lore;
    }

    @NotNull
    public String getAbbreviatedObjectValueString() {
        String valueString = this.getObjectValueString();
        valueString = StringUtils.abbreviate((String)valueString, (String)"...", (int)128);
        return valueString;
    }

    @NotNull
    public String getObjectTypeString() {
        return this.getObjectType().getName();
    }
}

