/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.event.graph;

import java.util.List;
import lombok.Generated;
import mod.fuji.core.event.graph.structure.EventConsumerInfo;
import mod.fuji.core.event.graph.structure.EventConsumerInfoList;
import mod.fuji.core.event.graph.structure.EventProducerInfo;
import mod.fuji.core.event.graph.structure.EventProducerInfoList;
import org.jetbrains.annotations.NotNull;

public class EventGraph {
    @NotNull
    private EventProducerInfoList producers = new EventProducerInfoList();
    @NotNull
    private EventConsumerInfoList consumers = new EventConsumerInfoList();

    private boolean matches(@NotNull EventProducerInfo eventProducerInfo, @NotNull EventConsumerInfo eventConsumerInfo) {
        return eventProducerInfo.getEventTypeClassName().equals(eventConsumerInfo.getEventTypeClassName()) && eventProducerInfo.getInjectorPriority() == eventConsumerInfo.getInjectorPriority();
    }

    @NotNull
    private List<EventProducerInfo> resolveProducers(@NotNull String mixinClassName) {
        return this.getProducers().stream().filter(it -> it.getDeclaringClassName().equals(mixinClassName)).toList();
    }

    @NotNull
    public List<EventConsumerInfo> resolveConsumers(@NotNull String mixinClassName) {
        return this.resolveProducers(mixinClassName).stream().flatMap(eventProducerInfo -> this.getConsumers().stream().filter(eventConsumerInfo -> this.matches((EventProducerInfo)eventProducerInfo, (EventConsumerInfo)eventConsumerInfo))).toList();
    }

    @NotNull
    @Generated
    public EventProducerInfoList getProducers() {
        return this.producers;
    }

    @NotNull
    @Generated
    public EventConsumerInfoList getConsumers() {
        return this.consumers;
    }

    @Generated
    public EventGraph setProducers(@NotNull EventProducerInfoList producers) {
        if (producers == null) {
            throw new NullPointerException("producers is marked non-null but is null");
        }
        this.producers = producers;
        return this;
    }

    @Generated
    public EventGraph setConsumers(@NotNull EventConsumerInfoList consumers) {
        if (consumers == null) {
            throw new NullPointerException("consumers is marked non-null but is null");
        }
        this.consumers = consumers;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventGraph)) {
            return false;
        }
        EventGraph other = (EventGraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventProducerInfoList this$producers = this.getProducers();
        EventProducerInfoList other$producers = other.getProducers();
        if (this$producers == null ? other$producers != null : !((Object)this$producers).equals(other$producers)) {
            return false;
        }
        EventConsumerInfoList this$consumers = this.getConsumers();
        EventConsumerInfoList other$consumers = other.getConsumers();
        return !(this$consumers == null ? other$consumers != null : !((Object)this$consumers).equals(other$consumers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventGraph;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventProducerInfoList $producers = this.getProducers();
        result = result * 59 + ($producers == null ? 43 : ((Object)$producers).hashCode());
        EventConsumerInfoList $consumers = this.getConsumers();
        result = result * 59 + ($consumers == null ? 43 : ((Object)$consumers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventGraph(producers=" + String.valueOf(this.getProducers()) + ", consumers=" + String.valueOf(this.getConsumers()) + ")";
    }

    @Generated
    public EventGraph() {
    }
}

