/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.job.abst;

import lombok.Generated;
import mod.fuji.core.auxiliary.RandomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;

public abstract class BaseJob
implements Job {
    private String jobGroup;
    private String jobName;
    private JobDetail jobDetail;
    private TriggerKey triggerKey;
    private boolean staticJob;

    public BaseJob(@Nullable String jobGroup, @Nullable String jobName, @Nullable JobDataMap jobDataMap, boolean staticJob) {
        if (jobGroup == null) {
            jobGroup = this.getClass().getName();
        }
        if (jobName == null) {
            jobName = RandomUtil.randomUUID();
        }
        if (jobDataMap == null) {
            jobDataMap = new JobDataMap();
        }
        this.jobGroup = jobGroup;
        this.jobName = jobName;
        this.jobDetail = JobBuilder.newJob(this.getClass()).withIdentity(new JobKey(jobName, jobGroup)).usingJobData(jobDataMap).build();
        this.triggerKey = new TriggerKey(jobName, jobGroup);
        this.staticJob = staticJob;
    }

    @NotNull
    public abstract Trigger makeTrigger();

    public String toString() {
        return "{jobGroup = %s, jobName = %s}".formatted(this.jobGroup, this.jobName);
    }

    @Generated
    public BaseJob() {
    }

    @Generated
    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    @Generated
    public TriggerKey getTriggerKey() {
        return this.triggerKey;
    }

    @Generated
    public boolean isStaticJob() {
        return this.staticJob;
    }
}

