/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_attachment.gui;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import mod.fuji.core.auxiliary.CollectionUtil;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.UuidHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.core.gui.component.gui.ConfirmSignGui;
import mod.fuji.core.gui.component.gui.PagedGui;
import mod.fuji.module.initializer.command_attachment.service.CommandAttachmentService;
import mod.fuji.module.initializer.command_attachment.structure.CommandAttachmentDataNode;
import mod.fuji.module.initializer.command_attachment.structure.attachment_entry.BaseCommandAttachmentEntry;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandAttachmentEditorGui
extends PagedGui<BaseCommandAttachmentEntry> {
    private final CommandAttachmentDataNode commandAttachmentDataNode;

    public CommandAttachmentEditorGui(@Nullable SimpleGui parent, @NotNull class_3222 player, @NotNull List<BaseCommandAttachmentEntry> entities, int pageIndex, CommandAttachmentDataNode commandAttachmentDataNode) {
        super(parent, player, TextHelper.getTextByKey(player, "command_attachment.editor.gui.title", commandAttachmentDataNode.getId()), entities, pageIndex);
        this.commandAttachmentDataNode = commandAttachmentDataNode;
        GuiHelper.Placer.setSlotInLastLine((SlotGuiInterface)this, 4, GuiHelper.Button.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "command_attachment.editor.help.lore")));
    }

    @Override
    @NotNull
    protected PagedGui<BaseCommandAttachmentEntry> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<BaseCommandAttachmentEntry> entities, int pageIndex) {
        return new CommandAttachmentEditorGui(parent, player, entities, pageIndex, this.commandAttachmentDataNode);
    }

    private static Optional<String> getTargetUuidForEditor(@NotNull class_3222 player) {
        Optional<String> lookingAtEntityUUID = WorldHelper.Raycast.getLookingAtEntity(player).map(UuidHelper::getAttachedUuid).filter(uuid -> CommandAttachmentService.findAttachmentDataNode(uuid).isPresent());
        if (lookingAtEntityUUID.isPresent()) {
            return lookingAtEntityUUID;
        }
        class_3218 world = EntityHelper.getServerWorld((class_1297)player);
        Optional<String> lookingAtBlockUUID = WorldHelper.Raycast.getLookingAtBlock(player).map(block -> UuidHelper.getAttachedUuid((class_1937)world, block)).filter(uuid -> CommandAttachmentService.findAttachmentDataNode(uuid).isPresent());
        if (lookingAtBlockUUID.isPresent()) {
            return lookingAtBlockUUID;
        }
        class_1799 mainHandStack = player.method_6047();
        Optional<String> mainHandItemUUID = UuidHelper.getAttachedUuid(mainHandStack);
        if (mainHandItemUUID.isPresent()) {
            return mainHandItemUUID;
        }
        return Optional.empty();
    }

    @NotNull
    public static CommandAttachmentEditorGui make(@NotNull class_3222 player, @NotNull CommandAttachmentDataNode dataNode) {
        CopyOnWriteArrayList<BaseCommandAttachmentEntry> entities = dataNode.getAttachments().getEntries();
        return new CommandAttachmentEditorGui(null, player, entities, 0, dataNode);
    }

    @NotNull
    public static CommandAttachmentEditorGui make(@NotNull class_3222 player) {
        return CommandAttachmentEditorGui.getTargetUuidForEditor(player).flatMap(CommandAttachmentService::findAttachmentDataNode).map(dataNode -> CommandAttachmentEditorGui.make(player, dataNode)).orElseThrow(() -> {
            TextHelper.sendTextByKey(player, "command_attachment.editor.no_target", new Object[0]);
            return new AbortCommandExecutionException();
        });
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull BaseCommandAttachmentEntry entity) {
        GuiElementBuilder builder = new GuiElementBuilder();
        builder.setItem(class_1802.field_8448);
        builder.setName(TextHelper.getTextByKey(this.player, "command_attachment.attachment", new Object[0]));
        builder.setLore(entity.asLore(this.player));
        builder.setCallback(clickType -> this.onEntityCallback((ClickType)clickType, entity));
        return builder.build();
    }

    private void reopenThis() {
        CommandAttachmentEditorGui.make(this.player, this.commandAttachmentDataNode).open();
    }

    private void onEntityCallback(@NotNull ClickType clickType, final @NotNull BaseCommandAttachmentEntry entity) {
        final CopyOnWriteArrayList<BaseCommandAttachmentEntry> entries = this.commandAttachmentDataNode.getAttachments().getEntries();
        if (clickType.isRight && clickType.shift) {
            new ConfirmSignGui((SlotGuiInterface)this.getBackendGui(), this.getPlayer()){

                @Override
                public void onConfirm() {
                    entries.remove(entity);
                    CommandAttachmentEditorGui.this.reopenThis();
                }
            }.open();
            return;
        }
        if (clickType.isLeft) {
            CollectionUtil.moveElementLeft(entries, entity);
            this.reopenThis();
            return;
        }
        if (clickType.isRight) {
            CollectionUtil.moveElementRight(entries, entity);
            this.reopenThis();
            return;
        }
    }
}

