/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.fuji.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.DocStringProviders;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.gui.component.gui.PagedGui;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentTypesInspectionGui
extends PagedGui<BaseArgumentTypeAdapter> {
    public ArgumentTypesInspectionGui(SimpleGui parent, class_3222 player, @NotNull List<BaseArgumentTypeAdapter> entities, int pageIndex) {
        super(parent, player, TextHelper.getTextByKey(player, "command.argument.type.gui.title", new Object[0]), entities, pageIndex);
    }

    public static ArgumentTypesInspectionGui inspectAll(SimpleGui parent, class_3222 player) {
        List<BaseArgumentTypeAdapter> adapters = BaseArgumentTypeAdapter.Registry.REGISTERED_COMMAND_ARGUMENT_TYPE_ADAPTERS;
        return new ArgumentTypesInspectionGui(parent, player, adapters, 0);
    }

    @Override
    @NotNull
    protected PagedGui<BaseArgumentTypeAdapter> makePage(@Nullable SimpleGui parent, @NotNull class_3222 player, class_2561 title, @NotNull List<BaseArgumentTypeAdapter> entities, int pageIndex) {
        return new ArgumentTypesInspectionGui(parent, player, entities, pageIndex);
    }

    @NotNull
    private class_1792 toItem(@NotNull BaseArgumentTypeAdapter entity) {
        if (entity.isVanillaMinecraftArgumentType()) {
            return class_1802.field_8836;
        }
        return class_1802.field_8239;
    }

    @DocStringProviders(value={@DocStringProvider(id=1754726496693L, value="This `argument type adapter` is used to `handle` a `vanilla` Minecraft argument type.\nA `vanilla` Minecraft argument type is a `built-in` type provided by the base Minecraft game.\nExamples include: `int`, `double`, `float`, `entity type`, `item type`, `block pos`...\n"), @DocStringProvider(id=1754726568501L, value="This `argument type adapter` is used to `handle` a `non-vanilla` Minecraft argument type.\nA `non-vanilla` Minecraft argument type is registered by a `module`.\nExamples include: `home name`, `warp name`, `jail name`...\n")})
    private List<class_2561> toDocumentTexts(@NotNull BaseArgumentTypeAdapter entity) {
        String docString = entity.isVanillaMinecraftArgumentType() ? DocumentUtil.getDocString(this.getPlayer(), 1754726496693L) : DocumentUtil.getDocString(this.getPlayer(), 1754726568501L);
        return TextHelper.getDocumentTextList(this.getPlayer(), docString);
    }

    @Override
    @NotNull
    protected GuiElementInterface toGuiElement(@NotNull BaseArgumentTypeAdapter entity) {
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "from_module", entity.getSourceModule()));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "command.argument.type.is_vanilla", entity.isVanillaMinecraftArgumentType()));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "command.argument.type.class", entity.getTypeClasses().stream().map(Class::getSimpleName).toList()));
        lore.add(TextHelper.getTextByKey(this.getPlayer(), "command.argument.type.name", entity.getTypeNames()));
        lore.add(TextHelper.TEXT_EMPTY);
        lore.addAll(this.toDocumentTexts(entity));
        GuiElementBuilder guiElementBuilder = new GuiElementBuilder().setName((class_2561)class_2561.method_43470((String)entity.getClass().getSimpleName())).setItem(this.toItem(entity)).setLore(lore);
        if (!entity.isVanillaMinecraftArgumentType()) {
            guiElementBuilder.glow();
        }
        return guiElementBuilder.build();
    }
}

