/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.kit.command.argument.adapter;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.exception.AbortCommandExecutionException;
import mod.fuji.module.initializer.kit.command.argument.wrapper.KitName;
import mod.fuji.module.initializer.kit.service.KitService;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class KitNameArgumentTypeAdapter
extends BaseArgumentTypeAdapter {
    @Override
    protected ArgumentType<?> makeArgumentType() {
        return StringArgumentType.string();
    }

    @Override
    public Object makeArgumentValue(@NotNull CommandContext<class_2168> context, @NotNull CommandArgument commandArgument) {
        String kitName = StringArgumentType.getString(context, (String)commandArgument.getArgumentName());
        if (!KitService.hasKit(kitName)) {
            TextHelper.sendTextByKey(context.getSource(), "kit.kit.not_found", kitName);
            throw new AbortCommandExecutionException();
        }
        return new KitName(StringArgumentType.getString(context, (String)commandArgument.getArgumentName()));
    }

    @Override
    public List<Class<?>> getTypeClasses() {
        return List.of(KitName.class);
    }

    @Override
    public List<String> getTypeNames() {
        return List.of("kit-name");
    }

    @Override
    @NotNull
    protected RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(@NotNull String argumentName) {
        return super.makeRequiredArgumentBuilder(argumentName).suggests(CommandHelper.Suggestion.iterable(KitService::listKitNames));
    }
}

