/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.gameplay.carpet.fake_player_manager.service;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.module.initializer.gameplay.carpet.fake_player_manager.FakePlayerManagerInitializer;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class FakePlayerManagerService {
    public static final Map<String, List<String>> player2fakePlayers = new HashMap<String, List<String>>();
    public static final Map<String, Long> player2expiration = new HashMap<String, Long>();

    private static <T> T withMyFakePlayers(@NotNull class_3222 player, Function<List<String>, T> function) {
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        List fakePlayers = player2fakePlayers.computeIfAbsent(playerName, k -> new ArrayList());
        return function.apply(fakePlayers);
    }

    public static void addMyFakePlayer(@NotNull class_3222 player, @NotNull String fakePlayerName) {
        FakePlayerManagerService.withMyFakePlayers(player, fakePlayers -> fakePlayers.add(fakePlayerName));
    }

    public static boolean isMyFakePlayer(@NotNull class_3222 player, @NotNull String fakePlayerName) {
        return FakePlayerManagerService.withMyFakePlayers(player, fakePlayers -> fakePlayers.stream().anyMatch(it -> it.equalsIgnoreCase(fakePlayerName)));
    }

    public static void renewMyFakePlayers(@NotNull class_3222 player) {
        int renewDuration = FakePlayerManagerInitializer.config.model().renew_duration_ms;
        long newExpirationTime = System.currentTimeMillis() + (long)renewDuration;
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        player2expiration.put(playerName, newExpirationTime);
        TextHelper.sendTextByKey(player, "fake_player_manager.renew.success", ChronosUtil.Formatter.formatDate(newExpirationTime));
    }

    public static boolean canSpawnMoreFakePlayers(@NotNull class_3222 player) {
        int capsLimit = FakePlayerManagerService.getFakePlayerCapsLimit();
        int currentCount = FakePlayerManagerService.getSpawnedFakePlayerCount(player);
        return currentCount < capsLimit;
    }

    private static Integer getSpawnedFakePlayerCount(@NotNull class_3222 player) {
        return FakePlayerManagerService.withMyFakePlayers(player, List::size);
    }

    public static int getFakePlayerCapsLimit() {
        int currentDays = ChronosUtil.getLocalDate().getDayOfWeek().getValue();
        LocalTime currentTime = ChronosUtil.getLocalTime();
        int currentMinutes = currentTime.getHour() * 60 + currentTime.getMinute();
        Optional<List> first = FakePlayerManagerInitializer.config.model().caps_limit_rules.stream().filter(it -> currentDays >= (Integer)it.get(0) && currentMinutes >= (Integer)it.get(1)).findFirst();
        return first.map(it -> (Integer)it.get(2)).orElse(-1);
    }

    public static boolean canManipulateFakePlayer(@NotNull CommandContext<class_2168> context, String fakePlayerName) {
        if (((ParsedCommandNode)context.getNodes().get(2)).getNode().getName().equals("shadow")) {
            return false;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (player == null) {
            return true;
        }
        if (CommandHelper.Requirement.isAdmin((class_2168)context.getSource())) {
            return true;
        }
        return FakePlayerManagerService.isMyFakePlayer(player, fakePlayerName);
    }

    @NotNull
    public static String getTransformedFakePlayerName(@NotNull String fakePlayerName) {
        return FakePlayerManagerInitializer.config.model().transform_name.replace("%name%", fakePlayerName).replace("%s", fakePlayerName);
    }
}

