/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.world.manager.service;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import mod.fuji.core.annotation.Unused;
import mod.fuji.core.auxiliary.IOUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.ServerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.server.lifecycle.ServerStartedEvent;
import mod.fuji.core.event.message.server.tick.ServerTickStartEvent;
import mod.fuji.core.service.bossbar.BossBarManager;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.core.structure.Pair;
import mod.fuji.core.structure.TeleportTicket;
import mod.fuji.module.initializer.world.manager.WorldInitializer;
import mod.fuji.module.initializer.world.manager.service.structure.DimensionCreationTicket;
import mod.fuji.module.initializer.world.manager.service.structure.DimensionDeletionTicket;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionDescriptor;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionLoader;
import mod.fuji.module.initializer.world.manager.structure.RuntimeDimensionMaker;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WorldService {
    private static final Set<DimensionCreationTicket> dimensionCreationQueue = new ReferenceOpenHashSet();
    private static final Set<DimensionDeletionTicket> dimensionDeletionTicketQueue = new ReferenceOpenHashSet();

    @EventConsumer
    private static void processDimensionCreationAndDeletionQueue(@Unused ServerTickStartEvent event) {
        dimensionDeletionTicketQueue.removeIf(WorldService::tryConsumeDimensionDeletionTicket);
        dimensionCreationQueue.removeIf(WorldService::tryConsumeDimensionCreationTicket);
    }

    public static void submitDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.world;
        WorldService.saveChunksBeforeUnloadingTheDimension(world);
        ServerHelper.executeSync(() -> dimensionDeletionTicketQueue.add(ticket));
    }

    private static void saveChunksBeforeUnloadingTheDimension(class_3218 world) {
        ServerHelper.executeSync(() -> {
            world.field_13957 = false;
            world.method_14178().method_66012();
            world.method_14178().method_12127(() -> true, false);
        });
    }

    public static void submitDimensionCreationTicket(DimensionCreationTicket ticket) {
        ServerHelper.executeSync(() -> dimensionCreationQueue.add(ticket));
    }

    private static boolean tryConsumeDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.getWorld();
        if (world.method_18456().isEmpty() && !WorldService.shouldDelayShutdown(world)) {
            WorldService.consumeDimensionDeletionTicket(ticket);
            return true;
        }
        WorldService.evacuatePlayers(world);
        return false;
    }

    private static boolean shouldDelayShutdown(class_3218 world) {
        return world.method_14178().field_17254.method_39992();
    }

    private static boolean tryConsumeDimensionCreationTicket(@NotNull DimensionCreationTicket ticket) {
        if (dimensionDeletionTicketQueue.stream().anyMatch(it -> RegistryHelper.getIdAsString((class_1937)it.world).equals(ticket.descriptor.dimension))) {
            return false;
        }
        WorldService.consumeDimensionCreationTicket(ticket);
        return true;
    }

    private static void consumeDimensionCreationTicket(@NotNull DimensionCreationTicket ticket) {
        RuntimeDimensionDescriptor descriptor = ticket.descriptor;
        try {
            Pair<class_3218, class_5363> result = RuntimeDimensionMaker.makeRuntimeDimension(descriptor);
            class_3218 dimension = result.getKey();
            class_5363 dimensionOptions = result.getValue();
            RuntimeDimensionLoader.loadRuntimeDimension(dimension, dimensionOptions);
            dimension.method_18765(() -> true);
            TextHelper.sendTextByKey(ticket.source, "world.dimension.created", ticket.descriptor.dimension);
        }
        catch (Exception e) {
            LogUtil.error("Failed to make RuntimeDimension instance: dimension descriptor = {}", descriptor, e);
        }
    }

    private static void evacuatePlayers(@NotNull class_3218 dimension) {
        ArrayList players = new ArrayList(dimension.method_18456());
        for (class_3222 player : players) {
            GlobalPos from = GlobalPos.of(player);
            GlobalPos to = WorldHelper.SpawnPos.getSafeServerSpawnPos();
            TeleportTicket ticket = TeleportTicket.makeVipTicket(player, from, to);
            BossBarManager.addTicket(ticket);
        }
    }

    private static void consumeDimensionDeletionTicket(@NotNull DimensionDeletionTicket ticket) {
        class_3218 world = ticket.getWorld();
        RuntimeDimensionLoader.unloadDimension(world);
        if (ticket.deleteWorldFiles) {
            WorldService.deleteDimensionFiles(world);
        }
        if (ticket.deleteRuntimeDimensionDescriptor) {
            String dimensionId = RegistryHelper.getIdAsString((class_1937)world);
            WorldService.deleteRuntimeDimensionDescriptor(dimensionId);
        }
        TextHelper.sendTextByKey(ticket.source, "world.dimension.deleted", RegistryHelper.getIdAsString((class_1937)ticket.world));
    }

    private static void deleteDimensionFiles(@NotNull class_3218 world) {
        MinecraftServer server = world.method_8503();
        class_5321 dimensionKey = world.method_27983();
        File worldDirectory = server.field_23784.method_27424(dimensionKey).toFile();
        IOUtil.deleteFilesAndPreserveDirs(worldDirectory);
    }

    public static boolean existsDimension(class_2960 dimensionId) {
        boolean dimensionExistedInRuntime = WorldHelper.getWorlds().stream().anyMatch(it -> RegistryHelper.getIdAsString((class_1937)it).equals(dimensionId.toString()));
        boolean dimensionExistedInConfig = WorldService.getRuntimeDimensionDescriptor(dimensionId.toString()).isPresent();
        return dimensionExistedInRuntime || dimensionExistedInConfig;
    }

    public static void deleteRuntimeDimensionDescriptor(String dimensionId) {
        Optional<RuntimeDimensionDescriptor> first = WorldInitializer.world.model().dimension_list.stream().filter(o -> o.getDimension().equals(dimensionId)).findFirst();
        first.ifPresent(dimensionNode -> {
            WorldInitializer.world.model().dimension_list.remove(dimensionNode);
            WorldInitializer.world.writeStorage();
        });
    }

    public static void saveRuntimeDimensionDescriptors() {
        WorldInitializer.config.writeStorage();
    }

    public static Optional<RuntimeDimensionDescriptor> getRuntimeDimensionDescriptor(String dimensionId) {
        return WorldInitializer.world.model().dimension_list.stream().filter(it -> it.dimension.equalsIgnoreCase(dimensionId)).findFirst();
    }

    public static List<RuntimeDimensionDescriptor> getRuntimeDimensionDescriptors() {
        return WorldInitializer.world.model().dimension_list;
    }

    @EventConsumer
    private static void loadRuntimeDimensions(@Unused ServerStartedEvent event) {
        WorldInitializer.world.model().dimension_list.stream().filter(RuntimeDimensionDescriptor::isAuto_load_on_server_startup).forEach(it -> {
            try {
                DimensionCreationTicket ticket = new DimensionCreationTicket(CommandHelper.Source.getConsoleCommandSource(), (RuntimeDimensionDescriptor)it);
                WorldService.submitDimensionCreationTicket(ticket);
                LogUtil.info("Load dimension {} into the server.", it.getDimension());
            }
            catch (Exception e) {
                LogUtil.error("Failed to load dimension `{}`", it, e);
            }
        });
    }
}

