/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_toolbox.warp;

import java.util.List;
import java.util.Optional;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.annotation.CommandTarget;
import mod.fuji.core.command.argument.wrapper.impl.GreedyString;
import mod.fuji.core.command.argument.wrapper.impl.ItemStackWrapper;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.service.string_splitter.StringSplitter;
import mod.fuji.core.structure.GlobalPos;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.command_toolbox.warp.config.model.WarpDataModel;
import mod.fuji.module.initializer.command_toolbox.warp.gui.WarpGui;
import mod.fuji.module.initializer.command_toolbox.warp.service.WarpService;
import mod.fuji.module.initializer.command_toolbox.warp.structure.WarpDescriptor;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@ColorBox(id=1751972643858L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Set a display name for a warp.\nIssue: `/warp set-name \\<warp\\> \\<blue\\>This is the display name`\n\n\u25c9 Set a lore for a warp.\nIssue: `/warp set-lore \\<warp\\> \\<blue\\>This is the first line|\\<red\\>This is the second line`\n")
@CommandNode(value="warp")
public class WarpInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<WarpDataModel> data = ObjectConfigurationHandler.ofModule("warp.json", WarpDataModel.class).enableAutoSaveFeature("0 * * ? * * *");

    @Document(id=1751825396093L, value="Teleport to the specified warp point.")
    @CommandNode(value="tp")
    private static int $tp(@CommandSource @CommandTarget class_3222 player, WarpDescriptor warpName) {
        WarpService.doWarp(warpName, player);
        return 1;
    }

    @Document(id=1751825400830L, value="Delete a warp point.")
    @CommandNode(value="unset")
    @CommandRequirement(level=4)
    private static int $unset(@CommandSource class_3222 player, WarpDescriptor warpName) {
        return WarpService.deleteWarp(warpName).map(unused -> {
            TextHelper.sendTextByKey(player, "warp.unset.success", warpName.getKey());
            return 1;
        }).orElse(0);
    }

    @Document(id=1751825406388L, value="Set current location as new wrap point.")
    @CommandNode(value="set")
    @CommandRequirement(level=4)
    private static int $set(@CommandSource class_3222 player, String warpName, Optional<Boolean> override) {
        if (WarpService.findWarp(warpName).isPresent() && !override.orElse(false).booleanValue()) {
            TextHelper.sendTextByKey(player, "warp.set.fail.need_override", warpName);
            return 0;
        }
        WarpService.createWarp(player, warpName);
        TextHelper.sendTextByKey(player, "warp.set.success", warpName);
        return 1;
    }

    @CommandNode
    private static int $root(@CommandSource class_2168 source) {
        return WarpInitializer.$list(source);
    }

    @Document(id=1751825410558L, value="List warp points.")
    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        return Optional.ofNullable(source.method_44023()).map(player -> {
            WarpGui.makeDefault(player).open();
            return 1;
        }).orElseGet(() -> {
            TextHelper.sendTextByKey(source, "warp.list", WarpInitializer.data.model().warps.keySet());
            return 1;
        });
    }

    @Document(id=1751825417554L, value="Set the display name for a warp.")
    @CommandNode(value="set-name")
    @CommandRequirement(level=4)
    private static int $setName(@CommandSource class_3222 player, WarpDescriptor warp, GreedyString name) {
        warp.setDisplayName((String)name.getValue());
        return 1;
    }

    @Document(id=1751825422424L, value="Set the item for a warp.")
    @CommandNode(value="set-item")
    @CommandRequirement(level=4)
    private static int $setItem(@CommandSource class_3222 player, WarpDescriptor warp, ItemStackWrapper itemStack) {
        warp.setItem(itemStack.getInputString());
        return 1;
    }

    @Document(id=1751825427963L, value="Set the lore for a warp.")
    @CommandNode(value="set-lore")
    @CommandRequirement(level=4)
    private static int $setLore(@CommandSource class_3222 player, WarpDescriptor warp, GreedyString lore) {
        List<String> split = StringSplitter.split((String)lore.getValue());
        warp.setLore(split);
        return 1;
    }

    @Document(id=1756241454472L, value="Set the position for a warp.")
    @CommandNode(value="set-position")
    @CommandRequirement(level=4)
    private static int $setPosition(@CommandSource class_3222 player, WarpDescriptor warp) {
        GlobalPos newPosition = GlobalPos.of(player);
        warp.setPosition(newPosition);
        return 1;
    }
}

