/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.builder.component;

import java.util.List;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.structure.JobDescriptor;
import mod.fuji.module.initializer.document.builder.component.DocumentBuilder;
import mod.fuji.module.initializer.document.builder.context.DocumentBuilderContext;
import mod.fuji.module.initializer.document.formatter.MarkdownDocumentFormatter;
import org.jetbrains.annotations.NotNull;

public class ModuleJobsDocumentBuilder
extends DocumentBuilder {
    @Override
    public void build(@NotNull DocumentBuilderContext documentBuilderContext) {
        List<JobDescriptor> jobs = JobDescriptor.getJobDescriptors().stream().filter(it -> it.getSourceModule().equals(documentBuilderContext.getModulePathString())).toList();
        if (!jobs.isEmpty()) {
            documentBuilderContext.getDocumentBuilder().append("## Jobs").append(System.lineSeparator());
            jobs.forEach(it -> this.build(documentBuilderContext, (JobDescriptor)it));
        }
    }

    private void build(@NotNull DocumentBuilderContext documentBuilderContext, @NotNull JobDescriptor jobDescriptor) {
        Class jobClass = jobDescriptor.getJobDetail().getJobClass();
        String jobSimpleClassName = ReflectionUtil.getSimpleClassName(jobClass);
        documentBuilderContext.getDocumentBuilder().append(":::job").append(System.lineSeparator()).append("- Job Name: `%s`".formatted(jobSimpleClassName)).append(System.lineSeparator());
        DocumentUtil.getClassDocumentString(null, jobClass).ifPresent(jobDocumentString -> {
            jobDocumentString = MarkdownDocumentFormatter.parseDocumentString(jobDocumentString);
            documentBuilderContext.getDocumentBuilder().append("- Document: %s".formatted(jobDocumentString)).append(System.lineSeparator());
        });
        documentBuilderContext.getDocumentBuilder().append(":::").append(System.lineSeparator());
    }
}

