/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.title.service;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlaceholderHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.document.descriptor.PlaceholderDescriptor;
import mod.fuji.module.initializer.title.TitleInitializer;
import mod.fuji.module.initializer.title.structure.TitleDescriptor;
import mod.fuji.module.initializer.title.structure.TitlePreference;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleService {
    @DocStringProvider(id=1753000916378L, value="Having this permission means obtaining a `title` with the specified `id`.\n")
    private static final PermissionDescriptor TITLE_OBTAINED_PERMISSION_DESCRIPTOR = new PermissionDescriptor("fuji.title.obtain.<title-id>", 1753000916378L);
    @DocStringProvider(id=1753006644552L, value="Returns the `display name` of `the active title` for the player.\n")
    private static final PlaceholderDescriptor ACTIVE_TITLE_PLACEHOLDER_DESCRIPTOR = new PlaceholderDescriptor("active_title", 1753006644552L);

    public static List<TitleDescriptor> getAllTitles() {
        return TitleInitializer.config.model().getTitleDescriptors();
    }

    public static boolean isTitleObtained(class_3222 player, String titleId) {
        return LuckpermsHelper.hasPermission(player.method_5667(), TITLE_OBTAINED_PERMISSION_DESCRIPTOR, titleId);
    }

    public static Optional<TitleDescriptor> getActiveTitle(class_3222 player) {
        return TitleService.withPreference(player, preference -> TitleService.getTitle(preference.getActiveTitleId()));
    }

    public static void setActiveTitle(class_3222 player, @Nullable String titleId) {
        TitleService.withPreference(player, preference -> {
            preference.setActiveTitleId(titleId);
            return null;
        });
    }

    public static <T> T withPreference(class_3222 player, Function<TitlePreference, T> function) {
        List<TitlePreference> preferences = TitleInitializer.data.model().getPreferences();
        String playerName = PlayerHelper.getPlayerName((class_1657)player);
        Optional<TitlePreference> first = preferences.stream().filter(it -> it.getPlayer().equals(playerName)).findFirst();
        TitlePreference titlePreference = first.orElseGet(() -> {
            TitlePreference temp = new TitlePreference();
            temp.setPlayer(playerName);
            temp.setActiveTitleId(TitleService.getDefaultActiveTitleId());
            preferences.add(temp);
            return temp;
        });
        T value = function.apply(titlePreference);
        TitleInitializer.data.writeStorage();
        return value;
    }

    @Nullable
    public static String getDefaultActiveTitleId() {
        return TitleInitializer.config.model().getDefaultActiveTitleId();
    }

    @NotNull
    public static String getNoTitleActiveText() {
        return TitleInitializer.config.model().getNoActiveTitleText();
    }

    public static List<TitleDescriptor> getObtainedTitles(class_3222 player) {
        return TitleService.getAllTitles().stream().filter(descriptor -> TitleService.isTitleObtained(player, descriptor.getId())).toList();
    }

    public static Optional<TitleDescriptor> getTitle(String titleId) {
        return TitleService.getAllTitles().stream().filter(descriptor -> descriptor.getId().equals(titleId)).findFirst();
    }

    public static void registerActiveTitlePlaceholder() {
        PlaceholderHelper.registerPlayerPlaceholder(ACTIVE_TITLE_PLACEHOLDER_DESCRIPTOR, player -> {
            Optional<TitleDescriptor> activeTitle = TitleService.getActiveTitle(player);
            if (activeTitle.isPresent()) {
                TitleDescriptor titleDescriptor = activeTitle.get();
                class_5250 titleText = TextHelper.getTextByValue(player, titleDescriptor.getDisplayName(), new Object[0]).method_27661();
                List<class_2561> loreTextList = TextHelper.getTextListByValue(player, titleDescriptor.getLore());
                class_5250 hoverText = TextHelper.Operators.condenseTextList(loreTextList);
                titleText.method_27696(class_2583.field_24360.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction((class_2561)hoverText)));
                return titleText;
            }
            return TextHelper.getTextByValue(player, TitleService.getNoTitleActiveText(), new Object[0]);
        });
    }
}

