/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JsonUtil {
    public static boolean equalsJsonElementType(@NotNull JsonElement a, @NotNull JsonElement b) {
        if (a.isJsonObject() && b.isJsonObject()) {
            return true;
        }
        if (a.isJsonArray() && b.isJsonArray()) {
            return true;
        }
        if (a.isJsonNull() && b.isJsonNull()) {
            return true;
        }
        if (a.isJsonPrimitive() && b.isJsonPrimitive()) {
            JsonPrimitive ap = a.getAsJsonPrimitive();
            JsonPrimitive bp = b.getAsJsonPrimitive();
            if (ap.isString() && bp.isString()) {
                return true;
            }
            if (ap.isBoolean() && bp.isBoolean()) {
                return true;
            }
            if (ap.isNumber() && bp.isNumber()) {
                return true;
            }
        }
        return false;
    }

    public static boolean existsNode(@NotNull JsonObject root, @NotNull String path) {
        String[] nodes = path.split("\\.");
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.has(node)) {
                return false;
            }
            if (!root.isJsonObject()) {
                return false;
            }
            root = root.getAsJsonObject(node);
        }
        String theLastKey = nodes[nodes.length - 1];
        return root.has(theLastKey);
    }

    public static boolean isEmpty(JsonObject obj) {
        return obj.size() == 0;
    }

    public static JsonElement readJsonElement(Path path) {
        JsonElement jsonElement;
        block6: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(path.toFile())));
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
                if (Collections.singletonList(reader).get(0) == null) break block6;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(reader).get(0) != null) {
                    ((Reader)reader).close();
                }
                throw throwable;
            }
            ((Reader)reader).close();
        }
        return jsonElement;
    }
}

