/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.config.model.ConfigModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.jetbrains.annotations.NotNull;

public class LogUtil {
    @NotNull
    private static final Logger MOD_LOGGER = LogUtil.makeLogger(StringUtils.capitalize((String)"fuji"));
    private static final boolean isConsoleSupportAnsiColor = LogUtil.isConsoleSupportAnsiColor();

    @NotNull
    private static Logger makeLogger(String name) {
        Logger logger = LogManager.getLogger((String)name);
        try {
            LogUtil.configureLogger(logger);
        }
        catch (Exception e) {
            return logger;
        }
        return logger;
    }

    private static void configureLogger(Logger logger) {
        String levelDefinedInEnv = System.getProperty("%s.level".formatted("fuji"));
        Configurator.setLevel((Logger)logger, (Level)Level.getLevel((String)levelDefinedInEnv));
    }

    private static boolean isConsoleSupportAnsiColor() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    private static String attachSourceModulePrefix(String message) {
        String prefix = "[%s] ".formatted(ReflectionUtil.findSourceModuleInCurrentStackTrace());
        return prefix + message;
    }

    public static void debug(String message, Object ... args) {
        ConfigModel.Core.Debug debugConfig = Configs.MAIN_CONTROL_CONFIG.model().core.debug;
        if (!debugConfig.log_debug_messages) {
            return;
        }
        message = LogUtil.attachSourceModulePrefix(message);
        if (debugConfig.log_debug_messages) {
            String prefix = isConsoleSupportAnsiColor ? "\u001b[37m" : "";
            String format = prefix + message;
            MOD_LOGGER.info(format, args);
        } else {
            MOD_LOGGER.debug(message, args);
        }
    }

    public static void info(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.info(message, args);
    }

    public static void warn(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.warn(message, args);
    }

    public static void error(String message, Object ... args) {
        message = LogUtil.attachSourceModulePrefix(message);
        MOD_LOGGER.error(message, args);
    }
}

