/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary;

import io.github.sakurawald.fuji.Fuji;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReflectionUtil {
    public static final String MODULE_INITIALIZER_GRAPH_FILE_NAME = "module-initializer-graph.txt";
    public static final String ARGUMENT_TYPE_ADAPTER_GRAPH_FILE_NAME = "argument-type-adapter-graph.txt";
    public static final String LANGUAGE_GRAPH_FILE_NAME = "language-graph.txt";
    public static final String MODULE_GRAPH_FILE_NAME = "module-graph.txt";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getCompileTimeGraph(String graphName) {
        ArrayList<String> arrayList;
        block8: {
            InputStream virtualInputStream = ReflectionUtil.class.getResourceAsStream(graphName);
            if (virtualInputStream == null) {
                LogUtil.warn("Failed to load the graph {} from virtual jar file. (Is the jar file damaged?)", graphName);
                throw new RuntimeException("Failed to load the graph " + graphName);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(virtualInputStream));
            try {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                arrayList = lines;
                if (Collections.singletonList(reader).get(0) == null) break block8;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return arrayList;
    }

    public static List<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(it -> it.isAnnotationPresent(annotation)).toList();
    }

    public static Path computeModuleConfigPath(Class<?> clazz) {
        String modulePath = ModuleManager.computeJoinedModulePath(clazz.getName());
        return ReflectionUtil.computeModuleConfigPath(modulePath);
    }

    public static Path computeModuleConfigPath(String modulePath) {
        String others = modulePath.replace(".", "/");
        return Fuji.MOD_CONFIG_PATH.resolve("modules").resolve(others);
    }

    public static boolean isPrimitiveWrapperType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    public static List<String> getStackTraceAsList(Throwable throwable) {
        return Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).toList();
    }

    @NotNull
    public static String getSimpleClassName(Class<?> clazz) {
        String simpleClassName = clazz.getSimpleName();
        if (simpleClassName.isBlank()) {
            simpleClassName = "ANONYMOUS-CLASS";
        }
        return simpleClassName;
    }

    public static String findSourceModuleInCurrentStackTrace() {
        return ReflectionUtil.findSourceModule(ReflectionUtil.getCurrentStackTraceAsModuleName());
    }

    private static String findSourceModule(List<String> splitModulePathList) {
        String result = "unknown";
        for (String splitModulePath : splitModulePathList) {
            result = splitModulePath;
            if (result.equals("core")) continue;
            return result;
        }
        return result;
    }

    private static List<String> getCurrentStackTraceAsClassNames() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).toList();
    }

    private static List<String> getCurrentStackTraceAsModuleName() {
        return ReflectionUtil.getCurrentStackTraceAsClassNames().stream().map(ModuleManager::computeJoinedModulePath).toList();
    }
}

