/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CommandHelper {
    public static final String UUID_ARGUMENT_NAME = "uuid";
    public static final int COMMAND_EXCEPTION_COLOR = 0xFF5F00;

    @NotNull
    public static String findCommandNodePath(@NotNull CommandNode<class_2168> node) {
        CommandDispatcher<class_2168> dispatcher = ServerHelper.getCommandDispatcher();
        assert (dispatcher != null);
        CharSequence[] array = dispatcher.getPath(node).toArray(new String[0]);
        return String.join((CharSequence)".", array);
    }

    public static String trimPathString(String path) {
        return StringUtils.strip((String)path, (String)".");
    }

    @NotNull
    public static String joinCommandNodePath(List<ParsedCommandNode<class_2168>> nodes) {
        return nodes.stream().map(it -> it.getNode().getName()).collect(Collectors.joining("."));
    }

    public static void updateCommandTree() {
        class_2170 commandManager = ServerHelper.getServer().method_3734();
        ServerHelper.getOnlinePlayers().forEach(arg_0 -> ((class_2170)commandManager).method_9241(arg_0));
    }

    public static List<CommandNode<class_2168>> getCommandNodes() {
        ArrayList<CommandNode<class_2168>> result = new ArrayList<CommandNode<class_2168>>();
        CommandDispatcher<class_2168> commandDispatcher = ServerHelper.getCommandDispatcher();
        assert (commandDispatcher != null);
        RootCommandNode root = commandDispatcher.getRoot();
        CommandHelper.collectCommandNodes(result, (CommandNode<class_2168>)root);
        return result;
    }

    private static void collectCommandNodes(List<CommandNode<class_2168>> collector, CommandNode<class_2168> parent) {
        parent.getChildren().forEach(it -> CommandHelper.collectCommandNodes(collector, (CommandNode<class_2168>)it));
        if (CommandHelper.isRootCommandNode(parent)) {
            collector.add(parent);
        }
    }

    private static boolean isRootCommandNode(CommandNode<class_2168> node) {
        return !node.getName().isEmpty();
    }

    @NotNull
    public static List<String> getPrefixesOfCommandPath(List<ParsedCommandNode<class_2168>> nodes) {
        ArrayList<String> prefixes = new ArrayList<String>();
        Object walkingPath = "";
        for (ParsedCommandNode<class_2168> node : nodes) {
            String currentNodeName = node.getNode().getName();
            walkingPath = (String)walkingPath + "." + currentNodeName;
            walkingPath = CommandHelper.trimPathString((String)walkingPath);
            prefixes.add((String)walkingPath);
        }
        return prefixes;
    }

    public static boolean canUseThisCommand(class_3222 player, String commandString) {
        class_2168 commandSource = player.method_5671();
        ParseResults parseResults = ServerHelper.getCommandDispatcher().parse(commandString, (Object)commandSource);
        CommandContextBuilder context = parseResults.getContext();
        if (!parseResults.getExceptions().isEmpty()) {
            return false;
        }
        List nodes = context.getNodes();
        if (nodes.isEmpty()) {
            return false;
        }
        return nodes.stream().map(ParsedCommandNode::getNode).allMatch(it -> it.canUse((Object)commandSource));
    }

    public static class_2168 getCommandSource(class_1297 entity) {
        return entity.method_5671();
    }

    public static <S> boolean isExecutedOnServerSide(CommandContextBuilder<S> context) {
        return context.getSource() instanceof class_2168;
    }

    public static String getCommandNodeType(CommandNode<class_2168> node) {
        if (node instanceof LiteralCommandNode) {
            return "LiteralCommandNode";
        }
        if (node instanceof ArgumentCommandNode) {
            return "ArgumentCommandNode";
        }
        if (node instanceof RootCommandNode) {
            return "RootCommandNode";
        }
        return "Unknown";
    }

    public static class Pattern {
        public static int playerOnlyCommand(@NotNull class_2168 source, @NotNull Function<class_3222, Integer> function) {
            class_3222 player = source.method_44023();
            if (player == null) {
                TextHelper.sendTextByKey(source, "command.player_only", new Object[0]);
                return 1;
            }
            return function.apply(player);
        }

        public static int itemInHandCommand(@NotNull class_2168 source, @NotNull BiFunction<class_3222, class_1799, Integer> consumer) {
            return Pattern.playerOnlyCommand(source, player -> {
                class_1799 mainHandStack = player.method_6047();
                if (mainHandStack.method_7960()) {
                    TextHelper.sendTextByKey(player, "item.empty.not_allow", new Object[0]);
                    return -1;
                }
                return (Integer)consumer.apply((class_3222)player, mainHandStack);
            });
        }

        public static boolean isCommandConfirmed(class_2168 source, Optional<Boolean> confirm) {
            boolean confirmed = confirm.orElse(false);
            if (!confirmed) {
                TextHelper.sendTextByKey(source, "operation.confirm.failed", new Object[0]);
            }
            return confirmed;
        }
    }

    public static class Suggestion {
        @NotNull
        public static <T> SuggestionProvider<class_2168> enums(Supplier<T[]> enumSupplier) {
            return (context, builder) -> {
                for (Object value : (Object[])enumSupplier.get()) {
                    builder.suggest(value.toString());
                }
                return builder.buildFuture();
            };
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> iterable(Supplier<Iterable<T>> iterableSupplier) {
            return (context, builder) -> {
                for (Object value : (Iterable)iterableSupplier.get()) {
                    builder.suggest(value.toString());
                }
                return builder.buildFuture();
            };
        }

        @NotNull
        public static <T> SuggestionProvider<class_2168> identifiers(class_5321<? extends class_2378<T>> registryKey) {
            return Suggestion.iterable(() -> RegistryHelper.ofRegistry(registryKey).method_10235());
        }
    }

    public static class Return {
        public static final int FAIL = -1;
        public static final int PASS = 0;
        public static final int SUCCESS = 1;

        private static int fromBoolean(boolean value) {
            return value ? 1 : -1;
        }

        public static int returnBoolean(class_2168 source, boolean value) {
            return Return.fromBoolean(value);
        }
    }
}

