/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.serialization.DynamicOps;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemStackHelper {
    private static final String LORE_NBT_KEY = "Lore";
    private static final String DISPLAY_NBT_KEY = "display";

    public static void setCustomName(class_1799 stack, class_2561 customName) {
        stack.method_7977(customName);
    }

    public static boolean hasCustomName(class_1799 stack) {
        return stack.method_7938();
    }

    public static List<class_2561> getLore(class_1799 stack) {
        return stack.method_7911(DISPLAY_NBT_KEY).method_10554(LORE_NBT_KEY, 8).stream().map(tag -> TextHelper.fromJson(tag.method_10714())).collect(Collectors.toList());
    }

    public static void setLore(class_1799 stack, List<class_2561> texts) {
        class_2487 display = stack.method_7911(DISPLAY_NBT_KEY);
        class_2499 loreItems = new class_2499();
        for (class_2561 text : texts) {
            loreItems.add((Object)class_2519.method_23256((String)TextHelper.toJson(text)));
        }
        display.method_10566(LORE_NBT_KEY, (class_2520)loreItems);
    }

    public static class_2487 getSkullOwner(class_1799 stack) {
        return stack.method_7941("SkullOwner");
    }

    public static boolean canCombine(class_1799 a, class_1799 b) {
        if (!a.method_31574(b.method_7909())) {
            return false;
        }
        if (a.method_7960() && b.method_7960()) {
            return true;
        }
        return Objects.equals(Nbt.getNbt(a), Nbt.getNbt(b));
    }

    public static boolean filterItemStack(@Nullable class_1799 itemStack, String keyword) {
        if (itemStack == null) {
            return false;
        }
        if (itemStack.method_7960()) {
            return false;
        }
        if (ItemStackHelper.filterItemName(itemStack, keyword)) {
            return true;
        }
        if (ItemStackHelper.filterItemMaterial(itemStack, keyword)) {
            return true;
        }
        return ItemStackHelper.filterItemLore(itemStack, keyword);
    }

    private static boolean filterItemMaterial(@NotNull class_1799 itemStack, String keyword) {
        return RegistryHelper.toString(itemStack.method_7909()).toLowerCase().contains(keyword.toLowerCase());
    }

    private static boolean filterItemName(class_1799 itemStack, String keyword) {
        String itemName = TextHelper.Operators.visitString(itemStack.method_7964());
        return itemName.toLowerCase().contains(keyword.toLowerCase());
    }

    private static boolean filterItemLore(class_1799 itemStack, String keyword) {
        boolean matched = ItemStackHelper.getLore(itemStack).stream().anyMatch(text -> TextHelper.Operators.visitString(text).toLowerCase().contains(keyword.toLowerCase()));
        return matched;
    }

    public static class Nbt {
        public static class_2520 toNbtAllowEmpty(class_1799 stack, class_7225.class_7874 wrapperLookup) {
            if (stack.method_7960()) {
                return new class_2487();
            }
            return Nbt.toNbt(stack, wrapperLookup, (class_2520)new class_2487());
        }

        public static class_1799 fromNbtOrEmpty(class_7225.class_7874 wrapperLookup, @Nullable class_2487 nbtCompound) {
            if (nbtCompound == null || nbtCompound.method_33133()) {
                return class_1799.field_8037;
            }
            return Nbt.fromNbt(wrapperLookup, (class_2520)nbtCompound).orElse(class_1799.field_8037);
        }

        public static class_2499 writeSlotsNode(@NotNull class_2499 node, @NotNull List<class_1799> stackList) {
            stackList.forEach(itemStack -> {
                class_2520 nbtAllowEmpty = Nbt.toNbtAllowEmpty(itemStack, RegistryHelper.getDefaultWrapperLookup());
                node.add((Object)nbtAllowEmpty);
            });
            return node;
        }

        @NotNull
        public static List<class_1799> readSlotsNode(@Nullable class_2499 node) {
            if (node == null) {
                return new ArrayList<class_1799>();
            }
            ArrayList<class_1799> ret = new ArrayList<class_1799>();
            for (int i = 0; i < node.size(); ++i) {
                ret.add(Nbt.fromNbtOrEmpty(RegistryHelper.getDefaultWrapperLookup(), NbtHelper.Primitives.getCompound(node, i)));
            }
            return ret;
        }

        public static void withNbt(class_1799 stack, Consumer<class_2487> nbtConsumer) {
            class_2487 targetNbt = Nbt.getNbt(stack);
            if (targetNbt == null) {
                targetNbt = new class_2487();
            }
            nbtConsumer.accept(targetNbt);
            Nbt.setNbt(stack, targetNbt);
        }

        @Nullable
        public static class_2487 getNbt(@NotNull class_1799 stack) {
            return stack.method_7969();
        }

        public static void setNbt(@NotNull class_1799 stack, @NotNull class_2487 newNbt) {
            stack.method_7980(newNbt);
        }

        public static class_2520 toNbt(class_1799 stack, class_7225.class_7874 wrapperLookup, class_2520 nbtElement) {
            if (stack.method_7960()) {
                throw new IllegalStateException("Cannot encode empty ItemStack");
            }
            return (class_2520)class_1799.field_24671.encode((Object)stack, (DynamicOps)class_2509.field_11560, (Object)nbtElement).getOrThrow(true, string -> LogUtil.debug("Failed to encode item: {}", string));
        }

        @NotNull
        public static class_1799 fromNbtOrBarrier(class_2520 nbtElement) {
            Optional<class_1799> itemStack = Nbt.fromNbt(RegistryHelper.getDefaultWrapperLookup(), nbtElement);
            return itemStack.orElseGet(() -> ((class_1792)class_1802.field_8077).method_7854());
        }

        public static Optional<class_1799> fromNbt(class_2520 nbtElement) {
            return Nbt.fromNbt(RegistryHelper.getDefaultWrapperLookup(), nbtElement);
        }

        public static Optional<class_1799> fromNbt(class_7225.class_7874 wrapperLookup, class_2520 nbtElement) {
            return class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)nbtElement).resultOrPartial(string -> LogUtil.debug("Failed to decode item: '{}'", string));
        }
    }
}

