/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.document.descriptor.MetaDescriptor;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.util.Tristate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LuckpermsHelper {
    private static LuckPerms instance;

    @Nullable
    private static LuckPerms getAPI() {
        if (instance == null) {
            try {
                instance = LuckPermsProvider.get();
            }
            catch (Exception e) {
                return null;
            }
            return instance;
        }
        return instance;
    }

    private static User loadUser(@NotNull LuckPerms api, UUID uuid) {
        UserManager userManager = api.getUserManager();
        if (userManager.isLoaded(uuid)) {
            return userManager.getUser(uuid);
        }
        CompletableFuture userFuture = userManager.loadUser(uuid);
        return (User)userFuture.join();
    }

    @NotNull
    public static Tristate getPermission(@NotNull UUID uuid, @Nullable PermissionDescriptor permission, Object ... arguments) {
        LuckPerms api = LuckpermsHelper.getAPI();
        if (api == null) {
            return Tristate.UNDEFINED;
        }
        if (permission == null) {
            return Tristate.UNDEFINED;
        }
        String permissionString = permission.withArguments(arguments);
        if (permissionString == null || permissionString.isEmpty()) {
            return Tristate.UNDEFINED;
        }
        User user = LuckpermsHelper.loadUser(api, uuid);
        return user.getCachedData().getPermissionData().checkPermission(permissionString);
    }

    public static boolean hasPermission(@NotNull UUID uuid, @Nullable PermissionDescriptor permissionDescriptor, Object ... arguments) {
        return LuckpermsHelper.getPermission(uuid, permissionDescriptor, arguments).asBoolean();
    }

    @NotNull
    public static <T> Optional<T> getMeta(@NotNull UUID uuid, @Nullable MetaDescriptor<T> metaDescriptor, Object ... arguments) {
        LuckPerms api = LuckpermsHelper.getAPI();
        if (api == null) {
            return Optional.empty();
        }
        if (metaDescriptor == null) {
            return Optional.empty();
        }
        String metaString = metaDescriptor.withArguments(arguments);
        if (metaString == null || metaString.isEmpty()) {
            return Optional.empty();
        }
        User user = LuckpermsHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getMetaValue(metaString, metaDescriptor.valueTransformer);
    }

    @Nullable
    public static String getPrefix(UUID uuid) {
        LuckPerms api = LuckpermsHelper.getAPI();
        if (api == null) {
            return null;
        }
        User user = LuckpermsHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getPrefix();
    }

    @Nullable
    public static String getSuffix(UUID uuid) {
        LuckPerms api = LuckpermsHelper.getAPI();
        if (api == null) {
            return null;
        }
        User user = LuckpermsHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getSuffix();
    }
}

