/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtHelper {

    public static class Primitives {
        @Nullable
        public static String getString(class_2487 root, String key) {
            return root.method_10558(key);
        }

        @Nullable
        public static class_2487 getCompound(class_2487 root, String key) {
            return root.method_10562(key);
        }

        @Nullable
        public static class_2487 getCompound(class_2499 list, int index) {
            return list.method_10602(index);
        }

        public static int getInt(class_2487 root, String key) {
            return root.method_10550(key);
        }

        public static float getFloat(class_2487 root, String key) {
            return root.method_10583(key);
        }

        public static double getDouble(class_2487 root, String key) {
            return root.method_10574(key);
        }
    }

    public static class Storage {
        private static void writeNbtFile(@NotNull class_2487 nbt, @NotNull Path filePath) {
            class_2507.method_10630((class_2487)nbt, (Path)filePath);
        }

        private static class_2487 readNbtFile(Path filePath) {
            return class_2507.method_10633((Path)filePath);
        }

        public static <T> T withNbtFileAndGetReturnValue(@NotNull Path filePath, @NotNull Function<class_2487, T> function) {
            class_2487 readNbt;
            if (Files.notExists(filePath, new LinkOption[0])) {
                Storage.writeNbtFile(new class_2487(), filePath);
            }
            if ((readNbt = Storage.readNbtFile(filePath)) == null) {
                LogUtil.error("Failed to read the nbt file in {}", filePath);
                throw new AbortCommandExecutionException();
            }
            T value = function.apply(readNbt);
            Storage.writeNbtFile(readNbt, filePath);
            return value;
        }

        public static void withNbtFile(@NotNull Path filePath, @NotNull Consumer<class_2487> function) {
            Storage.withNbtFileAndGetReturnValue(filePath, root -> {
                function.accept((class_2487)root);
                return null;
            });
        }
    }

    public static class Walker {
        private static <T extends class_2520> void setPath(@NotNull class_2487 root, @NotNull String nbtPath, T value) {
            String[] keys = nbtPath.split("\\.");
            for (int i = 0; i < keys.length - 1; ++i) {
                String node = keys[i];
                assert (root != null);
                if (!root.method_10545(node)) {
                    root.method_10566(node, (class_2520)new class_2487());
                }
                root = Primitives.getCompound(root, node);
            }
            String theLastKey = keys[keys.length - 1];
            assert (root != null);
            root.method_10566(theLastKey, value);
        }

        @Nullable
        private static class_2520 readPath(@NotNull class_2487 root, @NotNull String nbtPath) {
            String[] nodes = nbtPath.split("\\.");
            for (int i = 0; i < nodes.length - 1; ++i) {
                String node = nodes[i];
                assert (root != null);
                if (!root.method_10545(node)) {
                    LogUtil.error("Failed to read specified path {} in nbt {}. (Path not exists)", nbtPath, root);
                    throw new RuntimeException("Failed to read specified path in NBT.");
                }
                root = Primitives.getCompound(root, node);
            }
            String theLastKey = nodes[nodes.length - 1];
            assert (root != null);
            @Nullable class_2520 nbtElement = root.method_10580(theLastKey);
            return nbtElement;
        }

        public static <T extends class_2520> T withNbtElement(@NotNull class_2487 root, @NotNull String nbtPath, T defaultValue) {
            class_2520 nbtElement = Walker.readPath(root, nbtPath);
            if (nbtElement == null) {
                Walker.setPath(root, nbtPath, defaultValue);
                return defaultValue;
            }
            return (T)nbtElement;
        }
    }
}

