/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerHelper {
    private static final String DIMENSION_NBT_KEY = "Dimension";

    private static class_3222 makePlayer(@NotNull GameProfile gameProfile) {
        MinecraftServer server = ServerHelper.getServer();
        class_8791 syncedClientOptions = class_8791.method_53821();
        return new class_3222(server, server.method_30002(), gameProfile, syncedClientOptions);
    }

    private static void applyPlayerData(@NotNull class_3222 player, @Nullable class_2487 playerData) {
        if (playerData == null) {
            return;
        }
        if (playerData.method_10545(DIMENSION_NBT_KEY)) {
            String dimensionId = NbtHelper.Primitives.getString(playerData, DIMENSION_NBT_KEY);
            PlayerHelper.setServerWorld(player, dimensionId);
        }
    }

    public static class_3222 loadOfflinePlayer(String playerName) {
        Optional<GameProfile> gameProfile = PlayerHelper.getGameProfileByName(playerName);
        if (gameProfile.isEmpty()) {
            throw new IllegalArgumentException("Can't find player %s in usercache.json".formatted(playerName));
        }
        class_3222 player = PlayerHelper.makePlayer(gameProfile.get());
        class_2487 playerDataOpt = ServerHelper.getPlayerManager().method_14600(player);
        PlayerHelper.applyPlayerData(player, playerDataOpt);
        return player;
    }

    public static Optional<GameProfile> getGameProfileByName(String playerName) {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return Optional.empty();
        }
        return userCache.method_14515(playerName);
    }

    public static void setServerWorld(@NotNull class_3222 player, @Nullable String dimensionId) {
        class_3218 world = RegistryHelper.ofServerWorld(dimensionId);
        if (world != null) {
            player.method_51468(world);
        }
    }

    public static void playSound(class_3222 player, class_3414 soundEvent, class_3419 soundCategory, float volume, float pitch) {
        player.method_17356(soundEvent, soundCategory, volume, pitch);
    }

    public static int getPing(class_3222 player) {
        return player.field_13987.method_52405();
    }

    public static String getPropertyValue(Property property) {
        return property.value();
    }

    public static String getPlayerName(class_1657 player) {
        return player.method_7334().getName();
    }

    public static boolean isRealPlayer(@NotNull class_3222 player) {
        return player.getClass() == class_3222.class;
    }

    public static boolean isServerPlayer(class_1657 player) {
        return player instanceof class_3222;
    }

    public static boolean isOp(class_1657 player) {
        return ServerHelper.getServer().method_3760().method_14569(player.method_7334());
    }

    public static boolean isAdmin(class_2168 source) {
        return source.method_9259(4);
    }

    public static class_3218 getServerWorld(class_3222 player) {
        return (class_3218)player.method_37908();
    }
}

