/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2556;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryHelper {
    @NotNull
    public static String toString(@NotNull class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).toString();
    }

    @NotNull
    public static String toString(@NotNull class_1799 itemStack) {
        return RegistryHelper.toString(itemStack.method_7909());
    }

    @NotNull
    public static String toString(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).toString();
    }

    @NotNull
    public static String toString(@NotNull class_2680 blockState) {
        return RegistryHelper.toString(blockState.method_26204());
    }

    @NotNull
    public static String toString(@NotNull class_1297 entity) {
        return class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
    }

    @NotNull
    public static String toString(@NotNull class_1937 world) {
        return world.method_27983().method_29177().toString();
    }

    @NotNull
    public static String toString(@NotNull class_5321<?> registryKey) {
        return registryKey.method_29177().toString();
    }

    public static <T> class_2378<T> ofRegistry(class_5321<? extends class_2378<? extends T>> registryKey) {
        return ServerHelper.getServer().method_46221().method_45926().method_30530(registryKey);
    }

    public static <T> class_5321<T> ofRegistryKey(@NotNull class_5321<? extends class_2378<T>> keyOfRegistry, class_2960 identifier) {
        return class_5321.method_29179(keyOfRegistry, (class_2960)identifier);
    }

    @Nullable
    public static class_3218 ofServerWorld(@Nullable String identifier) {
        if (identifier == null) {
            return null;
        }
        class_5321 key = RegistryHelper.ofRegistryKey(class_7924.field_41223, RegistryHelper.makeIdentifier(identifier));
        return ServerHelper.getServer().method_3847(key);
    }

    @NotNull
    public static class_1792 ofItem(@NotNull String identifier) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_12829((String)identifier));
        if (class_1802.field_8162.equals(item)) {
            LogUtil.warn("Failed to find the item {} in registry, we will return BARRIER instead.", identifier);
            return class_1802.field_8077;
        }
        return item;
    }

    public static class_7225.class_7874 getDefaultWrapperLookup() {
        return ServerHelper.getServer().method_30611();
    }

    public static class_2960 makeIdentifier(String identifier) {
        return new class_2960(identifier);
    }

    public static <T> String getIdAsString(class_6880<T> entry) {
        return entry.method_40230().map(registryKey -> registryKey.method_29177().toString()).orElse("[unregistered]");
    }

    @Nullable
    public static <T> String findRegistryKeyByRegistryValueInTheSpecifiedRegistry(class_5321<? extends class_2378<? extends T>> registrySpecifier, Object theRegistryValue) {
        var ref = new Object(){
            private String result;
        };
        RegistryHelper.ofRegistry(registrySpecifier).method_40270().forEach(candidate -> {
            Optional candidateKey = candidate.method_40230();
            if (candidateKey.isPresent() && theRegistryValue.equals(candidate.field_36453)) {
                ref.result = ((class_5321)candidateKey.get()).method_29177().toString();
            }
        });
        return ref.result;
    }

    public static String getMessageTypeAsString(class_2556.class_7602 parameters) {
        class_2556 messageTypeObj = parameters.comp_919();
        String messageTypeString = RegistryHelper.findRegistryKeyByRegistryValueInTheSpecifiedRegistry(class_7924.field_41237, messageTypeObj);
        return messageTypeString;
    }

    public static void ensureIdentifierNamespaceIfFuji(class_2960 identifier) {
        if (!identifier.method_12836().equals("fuji")) {
            throw new IllegalArgumentException("The namespace of identifier must be \"fuji\": " + String.valueOf(identifier));
        }
    }
}

