/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2596;
import net.minecraft.class_2703;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerHelper {
    private static MinecraftServer server;

    public static Collection<class_3218> getWorlds() {
        return ServerHelper.getServer().field_4589.values();
    }

    public static Optional<class_3218> getWorld(String dimensionId) {
        return ServerHelper.getWorlds().stream().filter(it -> RegistryHelper.toString((class_1937)it).equals(dimensionId)).findFirst();
    }

    @Nullable
    public static CommandDispatcher<class_2168> getCommandDispatcher() {
        if (ServerHelper.getServer() == null || ServerHelper.getServer().method_3734() == null) {
            return null;
        }
        return ServerHelper.getServer().method_3734().method_9235();
    }

    public static class_3324 getPlayerManager() {
        return ServerHelper.getServer().method_3760();
    }

    public static List<class_3222> getOnlinePlayers() {
        return ServerHelper.getPlayerManager().method_14571();
    }

    public static List<String> getOnlinePlayerNames() {
        return ServerHelper.getOnlinePlayers().stream().map(PlayerHelper::getPlayerName).toList();
    }

    @Nullable
    public static class_3222 getOnlinePlayerByName(String name) {
        return ServerHelper.getOnlinePlayers().stream().filter(it -> PlayerHelper.getPlayerName((class_1657)it).equals(name)).findFirst().orElse(null);
    }

    @Nullable
    public static class_3222 getOnlinePlayerByNameIgnoreCase(String name) {
        return ServerHelper.getOnlinePlayers().stream().filter(it -> PlayerHelper.getPlayerName((class_1657)it).equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    public static Optional<class_3222> getOnlinePlayerByUuid(UUID uuid) {
        return ServerHelper.getOnlinePlayers().stream().filter(player -> player.method_5667().equals(uuid)).findFirst();
    }

    public static boolean isPlayerOnline(String playerName) {
        return ServerHelper.getOnlinePlayerByName(playerName) != null;
    }

    public static void sendPacketToAll(class_2596<?> packet) {
        ServerHelper.getPlayerManager().method_14581(packet);
    }

    public static void sendPacket(class_2596<?> packet, class_3222 player) {
        player.field_13987.method_14364(packet);
    }

    public static void sendPacketToAllExcept(class_2596<?> packet, class_3222 player) {
        ServerHelper.getPlayerManager().method_14571().stream().filter(it -> it != player).forEach(p -> ServerHelper.sendPacket(packet, player));
    }

    public static void updateDisplayName() {
        ServerHelper.getOnlinePlayers().forEach(player -> {
            class_2703 packet = new class_2703(class_2703.class_5893.field_29139, player);
            ServerHelper.sendPacketToAll(packet);
        });
    }

    public static Iterable<class_3193> getChunks(class_3218 world) {
        Iterable chunkHolders = world.method_14178().field_17254.method_17264();
        return chunkHolders;
    }

    public static List<GameProfile> getOfflineGameProfiles() {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return List.of();
        }
        return userCache.field_14312.values().stream().map(class_3312.class_3313::method_14519).toList();
    }

    public static Optional<GameProfile> getOfflineGameProfileByName(String playerName) {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return Optional.empty();
        }
        class_3312.class_3313 entry = (class_3312.class_3313)userCache.field_14312.get(playerName);
        if (entry == null || entry.method_14519() == null) {
            return Optional.empty();
        }
        return Optional.of(entry.method_14519());
    }

    @NotNull
    public static List<String> getOfflinePlayerNames() {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return List.of();
        }
        return userCache.field_14312.values().stream().map(it -> it.method_14519().getName()).toList();
    }

    public static boolean isClientSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static boolean isServerSide() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static void setServer(MinecraftServer server) {
        ServerHelper.server = server;
    }
}

