/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.auxiliary.minecraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.tag.TagRegistry;
import eu.pb4.placeholders.api.parsers.tag.TextTag;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.config.Configs;
import io.github.sakurawald.fuji.core.config.handler.impl.ResourceConfigurationHandler;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import io.github.sakurawald.fuji.core.document.auxiliary.DocumentUtil;
import io.github.sakurawald.fuji.core.document.structure.DocString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_7417;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ForDeveloper(value="The design of language system.\n1. Use hash map to map the language key into language value.\n2. Teh language value should be simple enough. (Reduce the usage of long sentence)\n3. Reduce the usage of `click event` and `hover event` tag in language value. (Use programmatically way to attach them)\n\n")
public class TextHelper {
    public static final class_2561 TEXT_NEWLINE = class_2561.method_30163((String)"\n");
    public static final class_2561 TEXT_SPACE = class_2561.method_30163((String)" ");
    public static final class_2561 TEXT_EMPTY = class_2561.method_43470((String)"");

    @ForDeveloper(value="This is the core method to map String into Text.")
    @NotNull
    public static class_2561 getText(@NotNull NodeParser parser, @Nullable Object audience, boolean isKey, String keyOrValue, Object ... args) {
        String languageValue;
        String string = languageValue = isKey ? Translator.getLanguageValueByKey(audience, keyOrValue) : keyOrValue;
        if (languageValue == null) {
            LogUtil.warn("The language value is null: parser = {}, audience = {}, isKey = {}, keyOrValue = {}, args = {}", parser, audience, isKey, keyOrValue, args);
            return class_2561.method_43470((String)"The language value is null, see the console.");
        }
        languageValue = TextHelper.formatStringArgs(languageValue, args);
        PlaceholderContext placeholderContext = Parsers.makePlaceholderContext(audience);
        ParserContext parserContext = ParserContext.of((ParserContext.Key)PlaceholderContext.KEY, (Object)placeholderContext);
        return parser.parseText(TextNode.of((String)languageValue), parserContext);
    }

    @NotNull
    private static String formatStringArgs(@NotNull String string, Object ... args) {
        if (args.length > 0) {
            try {
                return String.format(string, args);
            }
            catch (Exception e) {
                LogUtil.error("Failed to format arguments in language value.\nThe language value is `{}`.\nThe arguments are `{}`.\n\nPossible reasons:\n1. There may be a syntax mistake in the language file. (Try fix it, and issue `/fuji reload` to reload the language file)\n2. You have to write `%%` to mean `%` inside the Java Standard String Formatter. (https://docs.oracle.com/javase/8/docs/api/java/util/Formatter.html)\n3. Outdated language value. (The number of args is mis-matched, try delete the old language value, and issue `/fuji reload` to re-generate a new default value.)\n", string, args, e);
            }
        }
        return string;
    }

    @NotNull
    public static class_2561 getTextByKey(@Nullable Object audience, String languageKey, Object ... args) {
        return TextHelper.getText(Parsers.POWERFUL_PARSER, audience, true, languageKey, args);
    }

    @NotNull
    public static class_2561 getTextByValue(@Nullable Object audience, String languageValue, Object ... args) {
        return TextHelper.getText(Parsers.POWERFUL_PARSER, audience, false, languageValue, args);
    }

    public static class_2561 getTextByKeyAndReplaceTheKeyword(@Nullable Object audience, String languageKey, String keywordName) {
        String keywordKey = "keyword." + keywordName;
        String keywordValue = Translator.getLanguageValueByKey(audience, keywordKey);
        return TextHelper.getTextByKey(audience, languageKey, keywordValue);
    }

    @NotNull
    private static List<class_2561> getTextList(@Nullable Object audience, boolean isKey, String keyOrValue) {
        String languageValue = isKey ? Translator.getLanguageValueByKey(audience, keyOrValue) : keyOrValue;
        return Arrays.stream(TextHelper.splitStringIntoLines(languageValue)).map(line -> TextHelper.getTextByValue(audience, line, new Object[0])).toList();
    }

    private static String[] splitStringIntoLines(String string) {
        return string.split("\n|<newline>");
    }

    @NotNull
    public static List<class_2561> getTextListByKey(@Nullable Object audience, String key) {
        return TextHelper.getTextList(audience, true, key);
    }

    @NotNull
    public static List<class_2561> getTextListByValue(@Nullable Object audience, String value) {
        return TextHelper.getTextList(audience, false, value);
    }

    @ForDeveloper(value="Use this function to send a text to an audience.")
    public static void sendTextByKey(@NotNull Object audience, String languageKey, Object ... args) {
        String languageValue = Translator.getLanguageValueByKey(audience, languageKey);
        if (languageValue.startsWith("[suppress-sending]")) {
            LogUtil.debug("Suppress the sending of text: audience = {}, languageKey = {}, args = {}", audience, languageKey, args);
            return;
        }
        Sender.TextLocation textLocation = Sender.TextLocation.MESSAGE;
        if (languageValue.startsWith("[send-action-bar]")) {
            languageValue = languageValue.substring("[send-action-bar]".length());
            textLocation = Sender.TextLocation.ACTION_BAR;
        } else if (languageValue.startsWith("[send-main-title]")) {
            languageValue = languageValue.substring("[send-main-title]".length());
            textLocation = Sender.TextLocation.MAIN_TITLE;
        } else if (languageValue.startsWith("[send-sub-title]")) {
            languageValue = languageValue.substring("[send-sub-title]".length());
            textLocation = Sender.TextLocation.SUB_TITLE;
        }
        class_2561 text = TextHelper.getTextByValue(audience, languageValue, args);
        if (audience instanceof CommandContext) {
            CommandContext ctx = (CommandContext)audience;
            audience = ctx.getSource();
        }
        try {
            if (textLocation == Sender.TextLocation.ACTION_BAR) {
                Sender.sendActionBarToAudience(audience, text);
            } else if (textLocation == Sender.TextLocation.MAIN_TITLE) {
                Sender.sendTitleToAudience(audience, text, true);
            } else if (textLocation == Sender.TextLocation.SUB_TITLE) {
                Sender.sendTitleToAudience(audience, text, false);
            } else {
                Sender.sendMessageToAudience(audience, text);
            }
        }
        catch (Exception e) {
            String audienceType = audience == null ? null : audience.getClass().getName();
            LogUtil.error("Failed to send a text to the audience {}.\n\u25c9 Audience Type: {}\n\u25c9 Language Key: {}\n\u25c9 Args: {}\n\u25c9 Language Value: {}\n", audience, audienceType, languageKey, args, languageValue, e);
        }
    }

    public static void sendBroadcastByKey(@NotNull String key, Object ... args) {
        class_2561 text = TextHelper.getTextByKey(null, key, args);
        LogUtil.info(Operators.visitString(text), new Object[0]);
        for (class_3222 player : ServerHelper.getOnlinePlayers()) {
            TextHelper.sendTextByKey(player, key, args);
        }
    }

    public static void sendBroadcastByText(class_2561 text) {
        LogUtil.info(Operators.visitString(text), new Object[0]);
        for (class_3222 player : ServerHelper.getOnlinePlayers()) {
            player.method_43496(text);
        }
    }

    public static class_2561 fromJson(String tagString) {
        return class_2561.class_2562.method_10877((String)tagString);
    }

    public static String toJson(class_2561 text) {
        return class_2561.class_2562.method_10867((class_2561)text);
    }

    public static class_2561 getDocumentText(Object audience, String docString) {
        docString = DocumentUtil.compileDocumentString(docString);
        return TextHelper.getText(Parsers.STYLE_ONLY_PARSER, audience, false, docString, new Object[0]);
    }

    public static List<class_2561> getDocumentTextList(Object audience, String docString) {
        return Arrays.stream(TextHelper.splitStringIntoLines(docString)).map(line -> TextHelper.getDocumentText(audience, line)).toList();
    }

    static {
        Loader.writeDefaultLanguageFilesIfAbsent();
    }

    @ForDeveloper(value="The functions to map language key into language value for specified language code.")
    public static class Translator {
        @Nullable
        private static String getLanguageValueFromLanguageJson(@NotNull String languageCode, @NotNull String languageKey) {
            JsonObject languageJson = Loader.getLanguageJsonObject(languageCode);
            String defaultLanguageCode = Loader.getDefaultLanguageCode();
            if (Loader.isUnSupportedLanguageJsonObject(languageJson)) {
                languageCode = defaultLanguageCode;
                languageJson = Loader.getLanguageJsonObject(languageCode);
            }
            if (languageJson.has(languageKey)) {
                return languageJson.get(languageKey).getAsString();
            }
            if (!Loader.isDefaultLanguageCode(languageCode)) {
                LogUtil.warn("There is no language key {} in language code {}. We will fallback to default language code {} for this key.", languageKey, languageCode, defaultLanguageCode);
                return Translator.getLanguageValueFromLanguageJson(defaultLanguageCode, languageKey);
            }
            LogUtil.error("Failed to load the language key {} in the default language code. (default language code = {})", languageKey, defaultLanguageCode);
            return null;
        }

        @NotNull
        public static String getLanguageValueByKey(@Nullable Object audience, @NotNull String languageKey) {
            String languageCode = Loader.getAudienceLanguageCode(audience);
            String languageValue = Translator.getLanguageValueFromLanguageJson(languageCode, languageKey);
            if (languageValue != null) {
                return languageValue;
            }
            String dummyLanguageValue = "<red>(No key `%s` in language `%s`)</red>".formatted(languageKey, languageCode);
            LogUtil.warn("Failed to get language value: language code = {}, language key = {}, audience = {}", languageCode, languageKey, audience);
            return dummyLanguageValue;
        }
    }

    @ForDeveloper(value="The functions used to interact with the Text Parser.")
    public static class Parsers {
        private static final int THIS_STATIC_VARIABLE_IS_USED_TO_ENSURE_THE_EXTENDED_TAGS_ARE_REGISTERED_BEFORE_CREATING_THE_DEFAULT_PARSER = Parsers.registerExtendedTags();
        public static final NodeParser POWERFUL_PARSER = Parsers.makePowerfulParser();
        public static final NodeParser STYLE_ONLY_PARSER = Parsers.makeStyleOnlyParser();
        public static final NodeParser MINI_MESSAGE_ONLY_PARSER = Parsers.makeMiniMessageOnlyParser();
        public static final NodeParser PLACEHOLDER_ONLY_PARSER = Parsers.makePlaceholderOnlyParser();

        private static NodeParser makeMiniMessageOnlyParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().build();
        }

        @ForDeveloper(value="The style-only parser should support mini-message language and markdown language.")
        private static NodeParser makeStyleOnlyParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().markdown().build();
        }

        private static NodeParser makePowerfulParser() {
            return NodeParser.builder().quickText().simplifiedTextFormat().globalPlaceholders().markdown().build();
        }

        private static NodeParser makePlaceholderOnlyParser() {
            return NodeParser.builder().globalPlaceholders().build();
        }

        private static int registerExtendedTags() {
            TagRegistry.registerDefault((TextTag)TextTag.self((String)"newline", (String)"formatting", (boolean)true, (nodes, data, parser) -> new LiteralNode("\n")));
            return 0;
        }

        public static String escapeTags(String string) {
            return string.replace("<", "\\<").replace(">", "\\>").replace("*", "\\*").replace("%", "\\%");
        }

        public static class_2561 parseString(NodeParser parser, String input) {
            return parser.parseNode(input).toText();
        }

        @NotNull
        private static PlaceholderContext makePlaceholderContext(@Nullable Object audience) {
            PlaceholderContext placeholderContext;
            if (audience instanceof class_2168) {
                audience = ((class_2168)audience).method_44023();
            }
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                if (!PlayerHelper.isServerPlayer(playerEntity)) {
                    LogUtil.debug("PlayerEntity {} is a client-side player entity, we can't use it to make the context for placeholder parser. (I will just fallback to the server context).", new Object[0]);
                    return PlaceholderContext.of((MinecraftServer)ServerHelper.getServer());
                }
                placeholderContext = PlaceholderContext.of((class_1297)playerEntity);
            } else if (audience instanceof GameProfile) {
                GameProfile gameProfile = (GameProfile)audience;
                placeholderContext = PlaceholderContext.of((GameProfile)gameProfile, (MinecraftServer)ServerHelper.getServer());
            } else {
                placeholderContext = PlaceholderContext.of((MinecraftServer)ServerHelper.getServer());
            }
            return placeholderContext;
        }

        @NotNull
        public static String parsePlaceholderString(@Nullable Object audience, String value) {
            class_2561 text = TextHelper.getText(PLACEHOLDER_ONLY_PARSER, audience, false, value, new Object[0]);
            return Operators.visitString(text);
        }
    }

    @ForDeveloper(value="The functions to send a text to the audience.")
    public static class Sender {
        private static final String SUPPRESS_SENDING_STRING_MARKER = "[suppress-sending]";
        public static final String SEND_ACTION_BAR_MARKER = "[send-action-bar]";
        public static final String SEND_MAIN_TITLE_MARKER = "[send-main-title]";
        public static final String SEND_SUB_TITLE_MARKER = "[send-sub-title]";

        private static void sendMessageToServerPlayerEntity(class_3222 serverPlayerEntity, class_2561 text) {
            if (serverPlayerEntity.field_13987 == null) {
                LogUtil.warn("Failed to send the message to player {}, because its network handler is null. (Is it an dummy offline player entity?): text = {}", serverPlayerEntity, text);
                return;
            }
            serverPlayerEntity.method_7353(text, false);
        }

        private static void sendActionBarToAudience(Object audience, class_2561 text) {
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                playerEntity.method_7353(text, true);
                return;
            }
            LogUtil.warn("Don't know how to send an ACTION-BAR to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendTitleToAudience(Object audience, class_2561 text, boolean useMainTitle) {
            if (audience instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)audience;
                if (useMainTitle) {
                    Sender.sendTitleToServerPlayerEntity(serverPlayerEntity, text, (class_2561)class_2561.method_43473());
                } else {
                    Sender.sendTitleToServerPlayerEntity(serverPlayerEntity, (class_2561)class_2561.method_43473(), text);
                }
                return;
            }
            LogUtil.warn("Don't know how to send a TITLE to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendMessageToAudience(Object audience, class_2561 text) {
            if (audience instanceof class_3222) {
                class_3222 serverPlayerEntity = (class_3222)audience;
                Sender.sendMessageToServerPlayerEntity(serverPlayerEntity, text);
                return;
            }
            if (audience instanceof class_1657) {
                class_1657 playerEntity = (class_1657)audience;
                playerEntity.method_7353(text, false);
                return;
            }
            if (audience instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)audience;
                if (serverCommandSource.method_44023() != null) {
                    class_3222 player = serverCommandSource.method_44023();
                    Sender.sendMessageToServerPlayerEntity(player, text);
                    return;
                }
                serverCommandSource.method_45068(text);
                return;
            }
            LogUtil.warn("Don't know how to send a MESSAGE to audience {}. (text = {})", audience, text);
            throw new IllegalStateException();
        }

        private static void sendTitleToServerPlayerEntity(@NotNull class_3222 player, @NotNull class_2561 mainTitle, @NotNull class_2561 subTitle) {
            Sender.sendTitleToServerPlayerEntity(player, 10, 70, 20, mainTitle, subTitle);
        }

        public static void sendTitleToServerPlayerEntity(class_3222 player, int fadeInTicks, int stayTicks, int fadeOutTicks, class_2561 mainTitle, class_2561 subTitle) {
            player.field_13987.method_14364((class_2596)new class_5905(fadeInTicks, stayTicks, fadeOutTicks));
            player.field_13987.method_14364((class_2596)new class_5904(mainTitle));
            player.field_13987.method_14364((class_2596)new class_5903(subTitle));
        }

        public static enum TextLocation {
            MESSAGE,
            ACTION_BAR,
            MAIN_TITLE,
            SUB_TITLE;

        }
    }

    @ForDeveloper(value="The functions to operate on the Text domain entity.")
    public static class Operators {
        private static String visitString(class_7417 textContent) {
            StringBuilder stringBuilder = new StringBuilder();
            textContent.method_27659(string -> {
                stringBuilder.append(string);
                return Optional.empty();
            });
            return stringBuilder.toString();
        }

        public static String visitString(class_2561 text) {
            return text.getString();
        }

        public static class_5250 replaceTextWithMarker(class_2561 text, String marker, Supplier<class_2561> replacementSupplier) {
            return Operators.replaceTextWithRegex(text, "\\[%s\\]".formatted(marker), replacementSupplier);
        }

        public static class_5250 replaceTextWithRegex(class_2561 text, String regex, Supplier<class_2561> nonMemorizedReplacementSupplier) {
            nonMemorizedReplacementSupplier = Operators.makeMemoizeSupplier(nonMemorizedReplacementSupplier);
            return Operators.replaceText(text, Pattern.compile(regex), nonMemorizedReplacementSupplier);
        }

        private static class_5250 replaceText(class_2561 text, Pattern pattern, Supplier<class_2561> replacementSupplier) {
            class_5250 replacedText;
            String textString = Operators.visitString(text.method_10851());
            @Nullable List<class_2561> splits = Operators.trySplitString(textString, pattern, replacementSupplier);
            if (splits == null) {
                replacedText = text.method_27662();
            } else {
                class_5250 dummyRoot;
                replacedText = dummyRoot = class_2561.method_43473();
                splits.forEach(arg_0 -> ((class_5250)dummyRoot).method_10852(arg_0));
            }
            replacedText.method_27696(text.method_10866());
            for (class_2561 sibling : text.method_10855()) {
                class_5250 replacedSibling = Operators.replaceText(sibling, pattern, replacementSupplier);
                replacedText.method_10852((class_2561)replacedSibling);
            }
            return replacedText;
        }

        @Nullable
        private static List<class_2561> trySplitString(String string, Pattern pattern, Supplier<class_2561> replacementSupplier) {
            Matcher matcher = pattern.matcher(string);
            ArrayList<class_2561> ret = new ArrayList<class_2561>();
            int startIndex = 0;
            while (matcher.find()) {
                int i = matcher.start();
                if (i != startIndex) {
                    ret.add((class_2561)class_2561.method_43470((String)string.substring(startIndex, i)));
                }
                ret.add(replacementSupplier.get());
                startIndex = matcher.end();
            }
            if (ret.isEmpty()) {
                return null;
            }
            if (startIndex < string.length()) {
                ret.add((class_2561)class_2561.method_43470((String)string.substring(startIndex)));
            }
            return ret;
        }

        private static <T> Supplier<T> makeMemoizeSupplier(Supplier<T> delegate) {
            AtomicReference value = new AtomicReference();
            return () -> {
                Object val = value.get();
                if (val == null) {
                    val = value.updateAndGet(arg_0 -> Operators.lambda$makeMemoizeSupplier$1((Supplier)delegate, arg_0));
                }
                return val;
            };
        }

        private static /* synthetic */ Object lambda$makeMemoizeSupplier$1(Supplier delegate, Object cur) {
            return cur == null ? Objects.requireNonNull(delegate.get()) : cur;
        }
    }

    @ForDeveloper(value="The functions used to load language file from storage into memory, and resolve the suitable language json for given audience.")
    public static class Loader {
        private static final String LANGUAGE_FILE_PATH = "lang/";
        public static final Map<String, String> PLAYER_2_LANGUAGE_CODE = new ConcurrentHashMap<String, String>();
        public static final Map<String, JsonObject> LANGUAGE_CODE_2_LANGUAGE_JSON = new ConcurrentHashMap<String, JsonObject>();
        private static final JsonObject UNSUPPORTED_LANGUAGE_MARKER = new JsonObject();

        private static void writeDefaultLanguageFilesIfAbsent() {
            for (String languageFileName : ReflectionUtil.getCompileTimeGraph("language-graph.txt")) {
                new ResourceConfigurationHandler(LANGUAGE_FILE_PATH + languageFileName).readStorage();
            }
        }

        @ForDeveloper(value="Clear the loaded language file in memory.\nNote that once teh attempt to load a language file from storage is failed, a JsonObject maker named `UNSUPPORTED LANGUAGE` will be put into the map.\nLeading the subsequent attempts imply returns the marker.\n")
        public static void clearLoadedLanguageJsons() {
            LANGUAGE_CODE_2_LANGUAGE_JSON.clear();
        }

        public static void setPlayerLanguageCode(String playerName, String languageRepresentationUsedByMojang) {
            String unifiedLanguageCode = Loader.unifyLanguageCode(languageRepresentationUsedByMojang);
            PLAYER_2_LANGUAGE_CODE.put(playerName, unifiedLanguageCode);
        }

        private static void loadLanguageJsonIfAbsent(String languageCode) {
            if (LANGUAGE_CODE_2_LANGUAGE_JSON.containsKey(languageCode)) {
                return;
            }
            try {
                String languageFileName = languageCode + ".json";
                ResourceConfigurationHandler languageFileHandler = new ResourceConfigurationHandler(LANGUAGE_FILE_PATH + languageFileName){

                    @Override
                    public void beforeWriteStorage() {
                        this.model = Loader.makeSortedLanguageJsonObject((JsonObject)this.model);
                    }
                };
                languageFileHandler.readStorage();
                LANGUAGE_CODE_2_LANGUAGE_JSON.put(languageCode, ((JsonElement)languageFileHandler.model()).getAsJsonObject());
                LogUtil.info("Language {} loaded.", languageCode);
            }
            catch (Exception e) {
                LANGUAGE_CODE_2_LANGUAGE_JSON.put(languageCode, UNSUPPORTED_LANGUAGE_MARKER);
                LogUtil.error("Failed to load language `{}` from storage.", languageCode, e);
            }
        }

        private static String unifyLanguageCode(String input) {
            if (input == null || !input.contains("_")) {
                return input;
            }
            String[] components = input.split("_");
            String language = components[0].toLowerCase();
            String region = components[1].toUpperCase();
            return language + "_" + region;
        }

        @NotNull
        private static String getAudienceLanguageCode(@Nullable Object audience) {
            if (audience == null) {
                return Loader.getDefaultLanguageCode();
            }
            @Nullable class_1657 player = Loader.tryExtractPlayerEntity(audience);
            if (player == null) {
                return Loader.getDefaultLanguageCode();
            }
            String playerName = PlayerHelper.getPlayerName(player);
            String defaultLanguageCode = Loader.getDefaultLanguageCode();
            return PLAYER_2_LANGUAGE_CODE.computeIfAbsent(playerName, k -> defaultLanguageCode);
        }

        @Nullable
        private static class_1657 tryExtractPlayerEntity(@NotNull Object audience) {
            class_2168 commandSource;
            class_3222 player = null;
            if (audience instanceof CommandContext) {
                CommandContext commandContext = (CommandContext)audience;
                audience = commandContext.getSource();
            }
            if (audience instanceof class_3222) {
                player = (class_3222)audience;
            } else if (audience instanceof class_1657) {
                player = (class_1657)audience;
            } else if (audience instanceof class_2168 && (commandSource = (class_2168)audience).method_44023() != null) {
                player = commandSource.method_44023();
            }
            return player;
        }

        @NotNull
        private static JsonObject getLanguageJsonObject(String languageCode) {
            Loader.loadLanguageJsonIfAbsent(languageCode);
            return LANGUAGE_CODE_2_LANGUAGE_JSON.get(languageCode);
        }

        private static String getDefaultLanguageCode() {
            return Loader.unifyLanguageCode(Configs.MAIN_CONTROL_CONFIG.model().core.language.default_language);
        }

        public static boolean isDefaultLanguageCode(String languageCode) {
            return languageCode.equals(Loader.getDefaultLanguageCode());
        }

        public static boolean shouldUseBuiltInDocStrings() {
            if (Loader.isUsingEnglishAsTheDefaultLanguage()) {
                return true;
            }
            return Configs.MAIN_CONTROL_CONFIG.model().core.document.alwaysUseBuiltInDocStrings;
        }

        private static boolean isUsingEnglishAsTheDefaultLanguage() {
            return Loader.getDefaultLanguageCode().equalsIgnoreCase("en_US");
        }

        public static JsonObject makeSortedLanguageJsonObject(@NotNull JsonObject original) {
            TreeMap<String, JsonElement> sortedMap = new TreeMap<String, JsonElement>((a, b) -> {
                boolean aIsDocString = a.startsWith("docstring.");
                boolean bIsDocString = b.startsWith("docstring.");
                if (aIsDocString && !bIsDocString) {
                    return 1;
                }
                if (!aIsDocString && bIsDocString) {
                    return -1;
                }
                if (aIsDocString && bIsDocString) {
                    long aId = DocString.parseDocStringId(a);
                    long bId = DocString.parseDocStringId(b);
                    return Long.compare(aId, bId);
                }
                return a.compareTo((String)b);
            });
            for (Map.Entry entry : original.entrySet()) {
                sortedMap.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            JsonObject sortedJson = new JsonObject();
            for (Map.Entry entry : sortedMap.entrySet()) {
                sortedJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return sortedJson;
        }

        public static boolean isUnSupportedLanguageJsonObject(JsonObject languageJson) {
            return languageJson == UNSUPPORTED_LANGUAGE_MARKER;
        }
    }

    public static class Formatter {
        public static <K, V> class_5250 formatMap(Map<K, V> map) {
            class_5250 builder = class_2561.method_43473();
            boolean firstElement = true;
            builder.method_10852((class_2561)class_2561.method_43470((String)"{"));
            for (Map.Entry<K, V> entry : map.entrySet()) {
                if (!firstElement) {
                    builder.method_10852((class_2561)class_2561.method_43470((String)", "));
                }
                firstElement = false;
                class_2561 entryText = TextHelper.getTextByKey(null, "map.entry", entry.getKey(), entry.getValue());
                builder.method_10852(entryText);
            }
            builder.method_10852((class_2561)class_2561.method_43470((String)"}"));
            return builder;
        }
    }

    @ForDeveloper(value="The abstraction for text events.")
    public static class Events {

        public static class HoverEvent {
            public static class_2568 makeShowTextAction(class_2561 hoverText) {
                return new class_2568(class_2568.class_5247.field_24342, (Object)hoverText);
            }
        }

        public static class ClickEvent {
            public static class_2558 makeRunCommandAction(String command) {
                return new class_2558(class_2558.class_2559.field_11750, command);
            }

            public static class_2558 makeCopyToClipboardAction(String string) {
                return new class_2558(class_2558.class_2559.field_21462, string);
            }
        }
    }
}

