/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.argument.structure;

import io.github.sakurawald.fuji.core.command.annotation.CommandSource;
import io.github.sakurawald.fuji.core.command.annotation.CommandTarget;
import io.github.sakurawald.fuji.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import java.lang.reflect.Parameter;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Argument {
    private static final int THE_METHOD_PARAMETER_INDEX_FOR_LITERAL_ARGUMENT = -1;
    @Nullable
    private final Class<?> type;
    @NotNull
    private final String argumentName;
    private final boolean isOptional;
    @Nullable
    private final CommandRequirementDescriptor requirement;
    private boolean isCommandSource;
    private boolean isCommandTarget;
    @Nullable
    private String document;

    private Argument(@Nullable Class<?> type, @NotNull String argumentName, boolean isOptional, @Nullable CommandRequirementDescriptor requirement) {
        this.type = type;
        this.argumentName = argumentName;
        this.isOptional = isOptional;
        this.requirement = requirement;
    }

    public static Argument makeRequiredArgument(@NotNull Class<?> type, @NotNull String argumentName, boolean isOptional, @Nullable CommandRequirementDescriptor requirement) {
        return new Argument(type, argumentName, isOptional, requirement);
    }

    public static Argument makeLiteralArgument(@NotNull String argumentName, @Nullable CommandRequirementDescriptor requirement) {
        return new Argument(null, argumentName, false, requirement);
    }

    public Argument withDocument(@Nullable Document document) {
        if (document == null) {
            return this;
        }
        this.document = document.value();
        return this;
    }

    public boolean isRequiredArgument() {
        return this.type != null;
    }

    public boolean isLiteralArgument() {
        return !this.isRequiredArgument();
    }

    private String computeRequirementString() {
        if (this.requirement != null) {
            return "%d %s".formatted(this.requirement.getLevel(), this.requirement.getString()).trim();
        }
        return "";
    }

    public String toString() {
        Object flags = "";
        if (this.isCommandSource) {
            flags = (String)flags + "S";
        }
        if (this.isCommandTarget) {
            flags = (String)flags + "T";
        }
        if (this.isRequiredArgument()) {
            if (this.isOptional) {
                return "[%s](%s){%s}".formatted(this.argumentName, flags, this.computeRequirementString());
            }
            return "<%s>(%s){%s}".formatted(this.argumentName, flags, this.computeRequirementString());
        }
        return "%s{%s}".formatted(this.argumentName, this.computeRequirementString());
    }

    public String toHumanReadableString() {
        if (this.isLiteralArgument()) {
            return this.argumentName;
        }
        assert (this.getType() != null);
        if (this.isOptional) {
            return "[%s %s]".formatted(this.argumentName, this.getType().getSimpleName());
        }
        return "<%s %s>".formatted(this.argumentName, this.getType().getSimpleName());
    }

    public Argument markWithParameter(Parameter parameter) {
        this.markAsCommandSourceWithParameter(parameter);
        this.markAsCommandTargetWithParameter(parameter);
        return this;
    }

    private Argument markAsCommandSourceWithParameter(Parameter parameter) {
        if (!parameter.isAnnotationPresent(CommandSource.class)) {
            return this;
        }
        if (!this.isRequiredArgument()) {
            throw new IllegalArgumentException("The argument for command source must be a required argument.");
        }
        this.isCommandSource = true;
        return this;
    }

    private Argument markAsCommandTargetWithParameter(Parameter parameter) {
        if (!parameter.isAnnotationPresent(CommandTarget.class)) {
            return this;
        }
        if (!this.isRequiredArgument()) {
            throw new IllegalArgumentException("The argument for command target must be a required argument.");
        }
        if (!parameter.getType().equals(class_3222.class)) {
            throw new IllegalArgumentException("the annotation @CommandTarget can only be used in a parameter whose type is ServerPlayerEntity: class = %s, method = %s".formatted(parameter.getDeclaringExecutable().getName(), parameter.getDeclaringExecutable().getDeclaringClass().getSimpleName()));
        }
        this.isCommandTarget = true;
        return this;
    }

    @Nullable
    public Class<?> getType() {
        return this.type;
    }

    @NotNull
    public String getArgumentName() {
        return this.argumentName;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    @Nullable
    public CommandRequirementDescriptor getRequirement() {
        return this.requirement;
    }

    public boolean isCommandSource() {
        return this.isCommandSource;
    }

    public boolean isCommandTarget() {
        return this.isCommandTarget;
    }

    @Nullable
    public String getDocument() {
        return this.document;
    }
}

