/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.executor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.fuji.core.document.annotation.ForDeveloper;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CommandExecutor {
    public static void execute(@NotNull ExtendedCommandSource context, @NotNull List<String> commands) {
        commands.forEach(command -> CommandExecutor.execute(context, command));
    }

    @ForDeveloper(value="Cases:\n1. /run as console bad command\n2. /run as console run as player bad command\n3. /run as console run as player <player> run as console bad command\n4. /run as console run as player %player:name% run as fake-op %player:name% say I am %player:name%\n")
    public static int execute(@NotNull ExtendedCommandSource context, @NotNull String command) {
        command = context.expandCommand(command);
        LogUtil.debug("Executing command: command = `{}`, context = {}", command, context);
        try {
            return Objects.requireNonNull(ServerHelper.getCommandDispatcher()).execute(command, (Object)context.getExecutingSource());
        }
        catch (CommandSyntaxException e) {
            command = TextHelper.Parsers.escapeTags(command);
            if (!context.getExecutingSource().method_43737()) {
                LogUtil.warn("Failed to execute command: command = {}, context = {}", command, context);
            }
            TextHelper.sendTextByKey(context.getExecutingSource(), "command.execute.echo.executing_source", command, e.getMessage());
            if (!context.sameSource()) {
                TextHelper.sendTextByKey(context.getInitiatingSource(), "command.execute.echo.initiating_source", command, context.getExecutingSource().method_9214(), e.getMessage());
            }
            return -1;
        }
    }
}

