/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.core.command.structure;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.github.sakurawald.fuji.core.auxiliary.LogUtil;
import io.github.sakurawald.fuji.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.fuji.core.command.argument.structure.Argument;
import io.github.sakurawald.fuji.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.fuji.core.command.processor.CommandAnnotationProcessor;
import io.github.sakurawald.fuji.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.fuji.core.document.annotation.DocStringProvider;
import io.github.sakurawald.fuji.core.document.annotation.Document;
import io.github.sakurawald.fuji.core.document.descriptor.PermissionDescriptor;
import io.github.sakurawald.fuji.core.document.interfaces.SourceModuleGetter;
import io.github.sakurawald.fuji.core.manager.impl.module.ModuleManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandDescriptor
implements SourceModuleGetter {
    public final Method method;
    public final List<Argument> arguments;
    @Nullable
    private LiteralArgumentBuilder<class_2168> registerReturnValue;
    @Nullable
    public String document;

    public CommandDescriptor withDocument(@Nullable Document document) {
        if (document == null) {
            return this;
        }
        this.document = document.value();
        return this;
    }

    public CommandDescriptor(Method method, List<Argument> arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    private static LiteralArgumentBuilder<class_2168> makeLiteralArgumentBuilder(Argument argument) {
        return class_2170.method_9247((String)argument.getArgumentName());
    }

    private static RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(Argument argument) {
        return BaseArgumentTypeAdapter.getAdapter(argument.getType()).makeRequiredArgumentBuilder(argument.getArgumentName());
    }

    @DocStringProvider(id=1751999362278L, value="The permission used as the default string permission, for a command descriptor.")
    private static void setRequirementForArgumentBuilder(@NotNull ArgumentBuilder<class_2168, ?> builder, @Nullable CommandRequirementDescriptor requirement) {
        if (requirement == null) {
            return;
        }
        Predicate<class_2168> predicate = ctx -> {
            class_3222 player = ctx.method_44023();
            if (player == null) {
                return true;
            }
            if (requirement.getString() != null && !requirement.getString().isEmpty() && LuckpermsHelper.hasPermission(player.method_5667(), new PermissionDescriptor(requirement.getString(), 1751999362278L), new Object[0])) {
                return true;
            }
            return ctx.method_9259(requirement.getLevel());
        };
        builder.requires(predicate);
    }

    private static LiteralArgumentBuilder<class_2168> makeRootArgumentBuilder(List<ArgumentBuilder<class_2168, ?>> builders, Command<class_2168> command) {
        ArgumentBuilder root = null;
        for (int i = builders.size() - 1; i >= 0; --i) {
            ArgumentBuilder node = builders.get(i);
            if (root == null) {
                root = node;
                root = root.executes(command);
                continue;
            }
            root = node.then(root);
        }
        if (!(root instanceof LiteralArgumentBuilder)) {
            throw new IllegalArgumentException("The root argument builder must be a literal argument builder.");
        }
        return (LiteralArgumentBuilder)root;
    }

    private static String getCommandNodePath(CommandNode<class_2168> node) {
        StringBuilder sb = new StringBuilder();
        sb.append(node.getName());
        node.getChildren().forEach(child -> sb.append(".").append(CommandDescriptor.getCommandNodePath((CommandNode<class_2168>)child)));
        return sb.toString();
    }

    private static boolean unregister(CommandNode<class_2168> targetNode, CommandNode<class_2168> navigationNode) {
        if (targetNode == null) {
            return true;
        }
        navigationNode.getChildren().stream().toList().forEach(child -> {
            if (CommandDescriptor.unregister((CommandNode<class_2168>)targetNode.getChild(child.getName()), (CommandNode<class_2168>)child)) {
                targetNode.getChildren().removeIf(it -> it.getName().equals(child.getName()));
            }
        });
        return targetNode.getChildren() == null || targetNode.getChildren().isEmpty();
    }

    private static CommandNode<class_2168> computeRedirectTargetOfOptionalArgument(List<Argument> arguments) {
        List<String> prefix = arguments.stream().filter(arg -> !arg.isCommandSource()).takeWhile(arg -> !arg.isOptional()).map(Argument::getArgumentName).toList();
        return CommandAnnotationProcessor.COMMAND_DISPATCHER.findNode(prefix);
    }

    private static List<ArgumentBuilder<class_2168, ?>> makeArgumentBuilders(CommandDescriptor descriptor) {
        ArrayList builders = new ArrayList();
        descriptor.arguments.stream().filter(it -> !it.isOptional() && !it.isCommandSource()).forEach(argument -> {
            ArgumentBuilder<class_2168, ?> builder = CommandDescriptor.makeArgumentBuilder(argument);
            CommandDescriptor.setRequirementForArgumentBuilder(builder, argument.getRequirement());
            builders.add(builder);
        });
        return builders;
    }

    private static ArgumentBuilder<class_2168, ?> makeArgumentBuilder(Argument argument) {
        Object builder = argument.isRequiredArgument() ? CommandDescriptor.makeRequiredArgumentBuilder(argument) : CommandDescriptor.makeLiteralArgumentBuilder(argument);
        return builder;
    }

    protected static int handleCommandException(CommandContext<class_2168> ctx, Method method, Exception wrappedOrUnwrappedException) {
        Throwable theRealException = wrappedOrUnwrappedException;
        if (wrappedOrUnwrappedException instanceof InvocationTargetException) {
            theRealException = wrappedOrUnwrappedException.getCause();
        }
        if (theRealException instanceof AbortCommandExecutionException) {
            return -1;
        }
        CommandDescriptor.reportException((class_2168)ctx.getSource(), method, theRealException);
        return -1;
    }

    protected static boolean verifyCommandSource(CommandContext<class_2168> ctx, CommandDescriptor descriptor) {
        List<Argument> expectedCommandSources = descriptor.arguments.stream().filter(Argument::isCommandSource).toList();
        if (expectedCommandSources.isEmpty()) {
            return true;
        }
        if (expectedCommandSources.size() > 1) {
            throw new IllegalArgumentException("Expected only one command source: " + String.valueOf(descriptor));
        }
        return BaseArgumentTypeAdapter.getAdapter(expectedCommandSources.get(0).getType()).verifyCommandSource(ctx);
    }

    protected static void reportException(class_2168 source, Method method, Throwable throwable) {
        String errorString = "[Fuji Exception Catcher]\n- Source: %s\n- Module: %s\n- Method: %s\n- Message: %s\n\n".formatted(source.method_9214(), ModuleManager.computeSplitModulePath(method.getDeclaringClass().getName()), method.getName(), throwable);
        LogUtil.error(errorString, throwable);
        class_2583 style = class_2583.field_24360.method_36139(0xFF5F00);
        if (PlayerHelper.isAdmin(source)) {
            String stacktrace = String.join((CharSequence)"\n", ReflectionUtil.getStackTraceAsList(throwable));
            style.method_10949(TextHelper.Events.HoverEvent.makeShowTextAction(class_2561.method_30163((String)"Click to copy the stacktrace."))).method_10958(TextHelper.Events.ClickEvent.makeCopyToClipboardAction(stacktrace));
        }
        class_5250 report = TextHelper.getTextByValue(source, errorString, new Object[0]).method_27661().method_10862(style);
        source.method_45068((class_2561)report);
    }

    public String getCommandNodePath() {
        assert (this.registerReturnValue != null);
        return CommandDescriptor.getCommandNodePath((CommandNode<class_2168>)this.registerReturnValue.build());
    }

    public void unregister() {
        LogUtil.debug("Un-register command: {}", this);
        RootCommandNode root = CommandAnnotationProcessor.COMMAND_DISPATCHER.getRoot();
        assert (this.registerReturnValue != null);
        LiteralCommandNode navigationNode = this.registerReturnValue.build();
        CommandNode targetNode = root.getChild(navigationNode.getName());
        if (targetNode != null && CommandDescriptor.unregister((CommandNode<class_2168>)targetNode, (CommandNode<class_2168>)navigationNode)) {
            root.getChildren().removeIf(p -> p.getName().equals(navigationNode.getName()));
        }
        CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.remove(this);
    }

    protected List<Argument> collectArgumentsToMakeObjects() {
        return this.arguments.stream().filter(Argument::isRequiredArgument).toList();
    }

    protected List<Object> makeObjectsByArguments(CommandContext<class_2168> ctx) {
        ArrayList<Object> args = new ArrayList<Object>();
        for (Argument argument : this.collectArgumentsToMakeObjects()) {
            try {
                Object arg = BaseArgumentTypeAdapter.getAdapter(argument.getType()).makeParameterObject(ctx, argument);
                args.add(arg);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().startsWith("No such argument")) {
                    args.add(Optional.empty());
                    continue;
                }
                throw e;
            }
        }
        return args;
    }

    protected Command<class_2168> makeCommandFunctionClosure() {
        return ctx -> {
            int value;
            try {
                if (!CommandDescriptor.verifyCommandSource((CommandContext<class_2168>)ctx, this)) {
                    return -1;
                }
                List<Object> args = this.makeObjectsByArguments((CommandContext<class_2168>)ctx);
                value = (Integer)this.method.invoke(null, args.toArray());
            }
            catch (Exception wrappedOrUnwrappedException) {
                return CommandDescriptor.handleCommandException((CommandContext<class_2168>)ctx, this.method, wrappedOrUnwrappedException);
            }
            return value;
        };
    }

    public LiteralArgumentBuilder<class_2168> register() {
        LogUtil.debug("Register command: {}", this);
        LiteralArgumentBuilder<class_2168> root = this.registerNonOptionalArguments();
        this.registerOptionalArguments();
        this.registerReturnValue = root;
        CommandAnnotationProcessor.REGISTERED_COMMAND_DESCRIPTORS.add(this);
        return root;
    }

    private LiteralArgumentBuilder<class_2168> registerNonOptionalArguments() {
        List<ArgumentBuilder<class_2168, ?>> builders = CommandDescriptor.makeArgumentBuilders(this);
        Command<class_2168> command = this.makeCommandFunctionClosure();
        LiteralArgumentBuilder<class_2168> root = CommandDescriptor.makeRootArgumentBuilder(builders, command);
        CommandAnnotationProcessor.COMMAND_DISPATCHER.register(root);
        return root;
    }

    private void registerOptionalArguments() {
        CommandNode<class_2168> redirectTargetNode = CommandDescriptor.computeRedirectTargetOfOptionalArgument(this.arguments);
        this.arguments.stream().filter(Argument::isOptional).forEach(optionalArgument -> {
            ArgumentBuilder optionalArgumentBuilder = class_2170.method_9247((String)("--" + optionalArgument.getArgumentName())).then(((RequiredArgumentBuilder)CommandDescriptor.makeRequiredArgumentBuilder(optionalArgument).executes(redirectTargetNode.getCommand())).redirect(redirectTargetNode));
            redirectTargetNode.addChild(optionalArgumentBuilder.build());
        });
    }

    public String toString() {
        return "/" + this.arguments.stream().map(Argument::toString).collect(Collectors.joining(" "));
    }

    public String getCommandSyntax() {
        StringBuilder syntax = new StringBuilder().append("/");
        this.arguments.stream().filter(it -> !it.isCommandSource()).forEach(it -> syntax.append(it.toHumanReadableString()).append(" "));
        return syntax.toString();
    }

    public int getDefaultLevelPermission() {
        int minRequiredLevel = CommandRequirementDescriptor.getDefaultLevel();
        for (Argument argument : this.arguments) {
            if (argument.getRequirement() == null) continue;
            minRequiredLevel = Math.max(minRequiredLevel, argument.getRequirement().getLevel());
        }
        return minRequiredLevel;
    }

    public String getDefaultStringPermission() {
        String requiredString = CommandRequirementDescriptor.getDefaultString();
        for (Argument argument : this.arguments) {
            String string;
            if (argument.getRequirement() == null || (string = argument.getRequirement().getString()) == null || string.isBlank()) continue;
            requiredString = string;
            break;
        }
        return requiredString.isBlank() ? "none" : requiredString;
    }

    public boolean canBeExecutedByConsole() {
        for (Argument argument : this.arguments) {
            if (!argument.isCommandSource()) continue;
            assert (argument.getType() != null);
            return argument.getType().equals(CommandContext.class) || argument.getType().equals(class_2168.class);
        }
        return true;
    }

    @Override
    public String getSourceModule() {
        return ModuleManager.computeJoinedModulePath(this.method.getDeclaringClass().getName());
    }
}

